/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.storage;

import com.fancyinnovations.fancydialogs.FancyDialogsPlugin;
import com.fancyinnovations.fancydialogs.api.data.DialogData;
import com.fancyinnovations.fancydialogs.storage.DialogStorage;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import de.oliver.jdb.JDB;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class JsonDialogStorage
implements DialogStorage {
    private final JDB jdb = new JDB("plugins/FancyDialogs/data/dialogs");

    @Override
    public void save(DialogData dialog) {
        try {
            this.jdb.set(dialog.id(), dialog);
        }
        catch (IOException e) {
            FancyDialogsPlugin.get().getFancyLogger().error("Failed to save dialog " + dialog.id(), ThrowableProperty.of(e));
        }
    }

    @Override
    public void saveBatch(Collection<DialogData> dialogs) {
        for (DialogData dialog : dialogs) {
            this.save(dialog);
        }
    }

    @Override
    public void delete(DialogData dialog) {
        this.jdb.delete(dialog.id());
    }

    @Override
    public Collection<DialogData> loadAll() {
        ArrayList<DialogData> dialogs = new ArrayList();
        try {
            dialogs = this.jdb.getAll("", DialogData.class);
        }
        catch (IOException e) {
            FancyDialogsPlugin.get().getFancyLogger().error("Failed to load all dialogs", ThrowableProperty.of(e));
        }
        return dialogs;
    }
}

