/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancylib.versionFetcher;

import de.oliver.fancylib.versionFetcher.VersionFetcher;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class HangarVersionFetcher
implements VersionFetcher {
    private final String pluginName;
    private ComparableVersion newestVersion;

    public HangarVersionFetcher(String pluginName) {
        this.pluginName = pluginName;
        this.newestVersion = null;
    }

    @Override
    public ComparableVersion fetchNewestVersion() {
        if (this.newestVersion != null) {
            return this.newestVersion;
        }
        String versionStr = VersionFetcher.getDataFromUrl("https://hangar.papermc.io/api/v1/projects/" + this.pluginName + "/latestrelease");
        if (versionStr == null || versionStr.isEmpty()) {
            return null;
        }
        this.newestVersion = new ComparableVersion(versionStr);
        return this.newestVersion;
    }

    @Override
    public String getDownloadUrl() {
        return "https://hangar.papermc.io/Oliver/" + this.pluginName;
    }
}

