/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.listener;

import com.fancyinnovations.fancydialogs.FancyDialogsPlugin;
import com.fancyinnovations.fancydialogs.api.Dialog;
import com.fancyinnovations.fancydialogs.api.DialogAction;
import com.fancyinnovations.fancydialogs.api.data.DialogButton;
import com.fancyinnovations.fancydialogs.api.events.DialogButtonClickedEvent;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancysitula.api.packets.FS_ServerboundCustomClickActionPacket;
import de.oliver.fancysitula.api.packets.FS_ServerboundPacket;
import de.oliver.fancysitula.api.utils.FS_PacketListener;
import de.oliver.fancysitula.factories.FancySitula;
import java.util.Map;

public class CustomClickActionPacketListener {
    private static CustomClickActionPacketListener INSTANCE;
    private final FS_PacketListener packetListener = FancySitula.PACKET_LISTENER_FACTORY.createPacketListener(FS_ServerboundPacket.Type.CUSTOM_CLICK_ACTION);

    public CustomClickActionPacketListener() {
        this.packetListener.addListener(this::onPacketReceived);
    }

    public static CustomClickActionPacketListener get() {
        if (INSTANCE == null) {
            INSTANCE = new CustomClickActionPacketListener();
        }
        return INSTANCE;
    }

    private void onPacketReceived(FS_PacketListener.PacketReceivedEvent event) {
        FS_ServerboundPacket fS_ServerboundPacket = event.packet();
        if (!(fS_ServerboundPacket instanceof FS_ServerboundCustomClickActionPacket)) {
            return;
        }
        FS_ServerboundCustomClickActionPacket packet = (FS_ServerboundCustomClickActionPacket)fS_ServerboundPacket;
        if (!packet.getId().namespace().equals("fancysitula") && !packet.getId().namespace().equals("fancydialogs_dialog_action")) {
            return;
        }
        packet.getPayload().forEach((key, value) -> FancyDialogsPlugin.get().getFancyLogger().debug("Click action data Key: " + key + " value: " + value.toString(), new Property[0]));
        String dialogId = packet.getPayload().get("dialog_id");
        String buttonId = packet.getPayload().get("button_id");
        if (dialogId == null || buttonId == null) {
            return;
        }
        new DialogButtonClickedEvent(event.player(), dialogId, buttonId, packet.getPayload()).callEvent();
        if (dialogId.startsWith("confirmation_dialog_")) {
            return;
        }
        Dialog dialog = FancyDialogsPlugin.get().getDialogRegistry().get(dialogId);
        if (dialog == null) {
            FancyDialogsPlugin.get().getFancyLogger().warn("Received action for unknown dialog: " + dialogId, new Property[0]);
            return;
        }
        if (!dialog.isOpenedFor(event.player())) {
            FancyDialogsPlugin.get().getFancyLogger().warn("Received action for dialog: " + dialogId + " but it is not opened for player: " + event.player().getName(), new Property[0]);
            return;
        }
        DialogButton btn = dialog.getData().getButtonById(buttonId);
        if (btn == null) {
            FancyDialogsPlugin.get().getFancyLogger().warn("Received action for unknown button: " + buttonId + " in dialog: " + dialogId, new Property[0]);
            return;
        }
        for (DialogButton.DialogAction btnAction : btn.actions()) {
            DialogAction action = FancyDialogsPlugin.get().getActionRegistry().getAction(btnAction.name());
            if (action == null) {
                FancyDialogsPlugin.get().getFancyLogger().warn("Received action for unknown action: " + btnAction.name() + " in button: " + buttonId, new Property[0]);
                continue;
            }
            String data = btnAction.data();
            for (Map.Entry<String, String> entry : packet.getPayload().entrySet()) {
                data = data.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            action.execute(event.player(), dialog, data);
        }
    }

    public FS_PacketListener getPacketListener() {
        return this.packetListener;
    }
}

