/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.actions;

import com.fancyinnovations.fancydialogs.actions.defaultActions.ConsoleCommandDialogAction;
import com.fancyinnovations.fancydialogs.actions.defaultActions.MessageDialogAction;
import com.fancyinnovations.fancydialogs.actions.defaultActions.OpenDialogDialogAction;
import com.fancyinnovations.fancydialogs.actions.defaultActions.OpenRandomDialogDialogAction;
import com.fancyinnovations.fancydialogs.actions.defaultActions.PlayerCommandDialogAction;
import com.fancyinnovations.fancydialogs.actions.defaultActions.SendToServerDialogAction;
import com.fancyinnovations.fancydialogs.api.DialogAction;
import com.fancyinnovations.fancydialogs.api.DialogActionRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ActionRegistryImpl
implements DialogActionRegistry {
    private final Map<String, DialogAction> actions = new ConcurrentHashMap<String, DialogAction>();

    public ActionRegistryImpl() {
        this.registerDefaultActions();
    }

    private void registerDefaultActions() {
        this.registerAction("open_dialog", OpenDialogDialogAction.INSTANCE);
        this.registerAction("open_random_dialog", OpenRandomDialogDialogAction.INSTANCE);
        this.registerAction("message", MessageDialogAction.INSTANCE);
        this.registerAction("console_command", ConsoleCommandDialogAction.INSTANCE);
        this.registerAction("player_command", PlayerCommandDialogAction.INSTANCE);
        this.registerAction("send_to_server", SendToServerDialogAction.INSTANCE);
    }

    @Override
    public void registerAction(String actionId, DialogAction action) {
        if (this.actions.containsKey(actionId)) {
            throw new IllegalArgumentException("Action with ID " + actionId + " is already registered.");
        }
        this.actions.put(actionId, action);
    }

    @Override
    public DialogAction getAction(String actionId) {
        return this.actions.get(actionId);
    }
}

