/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.analytics;

import com.fancyinnovations.fancydialogs.FancyDialogsPlugin;
import com.fancyinnovations.fancydialogs.api.Dialog;
import com.fancyinnovations.fancydialogs.api.data.DialogButton;
import de.oliver.fancyanalytics.api.FancyAnalyticsAPI;
import de.oliver.fancyanalytics.api.metrics.MetricSupplier;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.sdk.events.Event;
import de.oliver.fancylib.VersionConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Analytics {
    private final FancyAnalyticsAPI api = new FancyAnalyticsAPI("ebed5533-b25e-44b3-894c-6898f64f5033", "2DNDnGE0NmQwYWE5ZTYzMDQzYTZJNoFa");

    public Analytics() {
        this.api.getConfig().setDisableLogging(true);
    }

    private void registerMetrics() {
        this.api.registerMinecraftPluginMetrics((Plugin)FancyDialogsPlugin.get());
        this.api.getExceptionHandler().registerLogger(FancyDialogsPlugin.get().getLogger());
        this.api.getExceptionHandler().registerLogger(Bukkit.getLogger());
        this.api.getExceptionHandler().registerLogger(FancyDialogsPlugin.get().getFancyLogger());
        this.api.registerStringMetric(new MetricSupplier<String>("language", () -> FancyDialogsPlugin.get().getTranslator().getSelectedLanguage().getLanguageCode()));
        this.api.registerStringMetric(new MetricSupplier<String>("release_channel", () -> FancyDialogsPlugin.get().getVersionConfig().getChannel()));
        this.api.registerStringMetric(new MetricSupplier<String>("release_platform", () -> FancyDialogsPlugin.get().getVersionConfig().getPlatform()));
        this.api.registerStringMetric(new MetricSupplier<String>("server_size", () -> {
            long onlinePlayers = Bukkit.getOnlinePlayers().size();
            if (onlinePlayers == 0L) {
                return "empty";
            }
            if (onlinePlayers <= 25L) {
                return "small";
            }
            if (onlinePlayers <= 100L) {
                return "medium";
            }
            if (onlinePlayers <= 500L) {
                return "large";
            }
            return "very_large";
        }));
        this.api.registerNumberMetric(new MetricSupplier<Double>("amount_dialogs", () -> FancyDialogsPlugin.get().getDialogRegistry().getAll().size()));
        this.api.registerNumberMetric(new MetricSupplier<Double>("amount_body_elements", () -> {
            long count = 0L;
            for (Dialog dialog : FancyDialogsPlugin.get().getDialogRegistry().getAll()) {
                count += (long)dialog.getData().body().size();
            }
            return count;
        }));
        this.api.registerNumberMetric(new MetricSupplier<Double>("amount_input_elements", () -> {
            long count = 0L;
            for (Dialog dialog : FancyDialogsPlugin.get().getDialogRegistry().getAll()) {
                count += (long)dialog.getData().inputs().all().size();
            }
            return count;
        }));
        this.api.registerNumberMetric(new MetricSupplier<Double>("amount_buttons", () -> {
            long count = 0L;
            for (Dialog dialog : FancyDialogsPlugin.get().getDialogRegistry().getAll()) {
                count += (long)dialog.getData().buttons().size();
            }
            return count;
        }));
        this.api.registerNumberMetric(new MetricSupplier<Double>("amount_actions", () -> {
            long count = 0L;
            for (Dialog dialog : FancyDialogsPlugin.get().getDialogRegistry().getAll()) {
                for (DialogButton button : dialog.getData().buttons()) {
                    count += (long)button.actions().size();
                }
            }
            return count;
        }));
    }

    private void checkIfVersionUpdated() {
        VersionConfig versionConfig = FancyDialogsPlugin.get().getVersionConfig();
        String currentVersion = versionConfig.getVersion();
        String lastVersion = "N/A";
        File versionFile = new File(FancyDialogsPlugin.get().getDataFolder(), "version.yml");
        if (!versionFile.exists()) {
            try {
                Files.write(versionFile.toPath(), currentVersion.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                FancyDialogsPlugin.get().getFancyLogger().warn("Could not write version file.", new Property[0]);
                return;
            }
        }
        try {
            lastVersion = new String(Files.readAllBytes(versionFile.toPath()));
        }
        catch (IOException e) {
            FancyDialogsPlugin.get().getFancyLogger().warn("Could not read version file.", new Property[0]);
            return;
        }
        if (!lastVersion.equals(currentVersion)) {
            FancyDialogsPlugin.get().getFancyLogger().info("Plugin has been updated from version " + lastVersion + " to " + currentVersion + ".", new Property[0]);
            this.api.sendEvent(new Event("PluginVersionUpdated", new HashMap<String, String>()).withProperty("from", lastVersion).withProperty("to", currentVersion).withProperty("commit_hash", versionConfig.getCommitHash()).withProperty("channel", versionConfig.getChannel()).withProperty("platform", versionConfig.getPlatform()));
            try {
                Files.write(versionFile.toPath(), currentVersion.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                FancyDialogsPlugin.get().getFancyLogger().warn("Could not write version file.", new Property[0]);
            }
        }
    }

    public void start() {
        this.registerMetrics();
        this.api.initialize();
        this.checkIfVersionUpdated();
    }
}

