/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.api;

import com.fancyinnovations.fancydialogs.api.data.DialogData;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

public abstract class Dialog {
    protected String id;
    protected DialogData data;
    protected Set<UUID> viewers;

    public Dialog(String id, DialogData data) {
        this.id = id;
        this.data = data;
        this.viewers = ConcurrentHashMap.newKeySet();
    }

    public Dialog() {
    }

    public abstract void open(Player var1);

    public abstract void close(Player var1);

    public String getId() {
        return this.id;
    }

    public DialogData getData() {
        return this.data;
    }

    public Set<UUID> getViewers() {
        return Set.copyOf(this.viewers);
    }

    public boolean isOpenedFor(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return this.viewers.contains(uuid);
    }

    public boolean isOpenedFor(Player player) {
        if (player == null) {
            return false;
        }
        return this.isOpenedFor(player.getUniqueId());
    }

    @ApiStatus.Internal
    public void addViewer(Player player) {
        if (player == null) {
            return;
        }
        this.viewers.add(player.getUniqueId());
    }

    @ApiStatus.Internal
    public void removeViewer(Player player) {
        if (player == null) {
            return;
        }
        this.viewers.remove(player.getUniqueId());
    }
}

