/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.config;

import com.fancyinnovations.config.ConfigHelper;
import com.fancyinnovations.fancydialogs.FancyDialogsPlugin;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class FancyDialogsConfig {
    private String language;
    private String logLevel;
    private String welcomeDialogID;
    private String quickActionsDialogID;

    public void load() {
        FancyDialogsPlugin.get().reloadConfig();
        FileConfiguration config = FancyDialogsPlugin.get().getConfig();
        this.language = (String)ConfigHelper.getOrDefault(config, "language", "default");
        config.setInlineComments("language", List.of("The language of the plugin."));
        this.logLevel = (String)ConfigHelper.getOrDefault(config, "log_level", "INFO");
        config.setInlineComments("log_level", List.of("The log level of the plugin. Possible values: DEBUG, INFO, WARN, ERROR."));
        this.welcomeDialogID = (String)ConfigHelper.getOrDefault(config, "welcome_dialog_id", "welcome_to_fancydialogs");
        config.setInlineComments("welcome_dialog_id", List.of("The ID of the dialog which will be shown to the player when they join the server for the first time."));
        this.quickActionsDialogID = (String)ConfigHelper.getOrDefault(config, "quick_actions_dialog_id", "quick_actions");
        config.setInlineComments("quick_actions_dialog_id", List.of("The ID of the dialog which will be shown to the player when they click on the quick actions key ('G' by default)."));
        FancyDialogsPlugin.get().saveConfig();
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getWelcomeDialogID() {
        return this.welcomeDialogID;
    }

    public String getQuickActionsDialogID() {
        return this.quickActionsDialogID;
    }
}

