/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.versions.v1_21_6.packets;

import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.api.packets.FS_ClientboundSetEntityDataPacket;
import de.oliver.fancysitula.api.utils.reflections.ReflectionUtils;
import de.oliver.fancysitula.versions.v1_21_6.utils.VanillaPlayerAdapter;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.inventory.ItemStack;

public class ClientboundSetEntityDataPacketImpl
extends FS_ClientboundSetEntityDataPacket {
    public ClientboundSetEntityDataPacketImpl(int entityId, List<FS_ClientboundSetEntityDataPacket.EntityData> entityData) {
        super(entityId, entityData);
    }

    @Override
    public Object createPacket() {
        ArrayList<SynchedEntityData.DataValue> dataValues = new ArrayList<SynchedEntityData.DataValue>();
        for (FS_ClientboundSetEntityDataPacket.EntityData data : this.entityData) {
            try {
                Class<?> entityClass = Class.forName(data.getAccessor().entityClassName());
                EntityDataAccessor accessor = (EntityDataAccessor)ReflectionUtils.getStaticField(entityClass, data.getAccessor().accessorFieldName());
                Object vanillaValue = data.getValue();
                if (data.getValue() == null) continue;
                Object object = data.getValue();
                if (object instanceof Component) {
                    Component c = (Component)object;
                    vanillaValue = PaperAdventure.asVanilla((Component)c);
                }
                if ((object = data.getValue()) instanceof ItemStack) {
                    ItemStack i = (ItemStack)object;
                    vanillaValue = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)i);
                }
                if ((object = data.getValue()) instanceof BlockState) {
                    BlockState b = (BlockState)object;
                    vanillaValue = ((CraftBlockState)b).getHandle();
                }
                dataValues.add(SynchedEntityData.DataValue.create((EntityDataAccessor)accessor, (Object)vanillaValue));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return new ClientboundSetEntityDataPacket(this.entityId, dataValues);
    }

    @Override
    public void sendPacketTo(FS_RealPlayer player) {
        ClientboundSetEntityDataPacket packet = (ClientboundSetEntityDataPacket)this.createPacket();
        ServerPlayer vanillaPlayer = VanillaPlayerAdapter.asVanilla(player.getBukkitPlayer());
        vanillaPlayer.connection.send((Packet)packet);
    }
}

