/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.api.utils.reflections;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class ReflectionUtils {
    private static Unsafe getUnsafe() throws Exception {
        Field field = Unsafe.class.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        return (Unsafe)field.get(null);
    }

    public static <T> T createUnsafeInstance(Class<T> clazz) throws Exception {
        Unsafe unsafe = ReflectionUtils.getUnsafe();
        return (T)unsafe.allocateInstance(clazz);
    }

    public static <T> T createInstance(Class<T> clazz) throws Exception {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    public static Object getField(Object object, String fieldName) throws Exception {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    public static void setField(Object object, String fieldName, Object value) throws Exception {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(object, value);
    }

    public static void setFinalField(Object target, String fieldName, Object value) throws Exception {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        Unsafe unsafe = ReflectionUtils.getUnsafe();
        long offset = unsafe.objectFieldOffset(field);
        if (field.getType() == Integer.TYPE) {
            unsafe.putInt(target, offset, (Integer)value);
        } else if (field.getType() == Long.TYPE) {
            unsafe.putLong(target, offset, (Long)value);
        } else if (field.getType() == Double.TYPE) {
            unsafe.putDouble(target, offset, (Double)value);
        } else if (field.getType() == Float.TYPE) {
            unsafe.putFloat(target, offset, ((Float)value).floatValue());
        } else if (field.getType() == Boolean.TYPE) {
            unsafe.putBoolean(target, offset, (Boolean)value);
        } else if (field.getType() == Byte.TYPE) {
            unsafe.putByte(target, offset, (Byte)value);
        } else if (field.getType() == Short.TYPE) {
            unsafe.putShort(target, offset, (Short)value);
        } else if (field.getType() == Character.TYPE) {
            unsafe.putChar(target, offset, ((Character)value).charValue());
        } else {
            unsafe.putObject(target, offset, value);
        }
    }

    public static <T> T getStaticField(Class<?> clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(null);
    }
}

