/*
 * Decompiled with CFR 0.152.
 */
package me.imgalvin.restrictedflying;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedFlying
implements ModInitializer {
    public static final String MOD_ID = "restricted-flying";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"restricted-flying");
    public static Set<class_5321<class_1937>> allowedFlightDimensions = new HashSet<class_5321<class_1937>>();
    private static Path configPath;
    private static final SuggestionProvider<class_2168> DIMENSION_SUGGESTIONS;

    public void onInitialize() {
        LOGGER.info("Restricted Flying mod is initializing!");
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            for (class_3222 player : world.method_18456()) {
                class_5321 dimension;
                if (!player.method_6128() || allowedFlightDimensions.contains(dimension = player.method_37908().method_27983())) continue;
                player.method_66281();
                player.method_7353((class_2561)class_2561.method_43470((String)"Elytra flight is disabled in this dimension."), true);
                class_1799 chestItem = player.method_6118(class_1304.field_6174);
                if (!chestItem.method_7909().toString().toLowerCase().contains("elytra")) continue;
                class_1799 elytraCopy = chestItem.method_7972();
                player.method_5673(class_1304.field_6174, class_1799.field_8037);
                player.method_7329(elytraCopy, false, true);
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"noflying").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"reload").executes(ctx -> {
            RestrictedFlying.loadConfig((class_2168)ctx.getSource());
            return 1;
        }))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2232.method_9441()).suggests(DIMENSION_SUGGESTIONS).executes(ctx -> {
            class_2960 id = class_2232.method_9443((CommandContext)ctx, (String)"dimension");
            if (id == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid dimension identifier."));
                return 0;
            }
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
            if (allowedFlightDimensions.add((class_5321<class_1937>)key)) {
                RestrictedFlying.saveConfig((class_2168)ctx.getSource());
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Added " + String.valueOf(id) + " to allowed flight dimensions.")), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Dimension " + String.valueOf(id) + " is already allowed.")), false);
            }
            return 1;
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2232.method_9441()).suggests(DIMENSION_SUGGESTIONS).executes(ctx -> {
            class_2960 id = class_2232.method_9443((CommandContext)ctx, (String)"dimension");
            if (id == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid dimension identifier."));
                return 0;
            }
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
            if (allowedFlightDimensions.remove(key)) {
                RestrictedFlying.saveConfig((class_2168)ctx.getSource());
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed " + String.valueOf(id) + " from allowed flight dimensions.")), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Dimension " + String.valueOf(id) + " is not in the allowed list.")), false);
            }
            return 1;
        })))).then(class_2170.method_9247((String)"show").executes(ctx -> {
            StringBuilder sb = new StringBuilder("Allowed flight dimensions: ");
            if (allowedFlightDimensions.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"No flying is allowed in any dimensions").method_27692(class_124.field_1061), false);
                return 1;
            }
            for (class_5321<class_1937> key : allowedFlightDimensions) {
                sb.append(key.method_29177().toString()).append(", ");
            }
            if (!sb.isEmpty()) {
                sb.setLength(sb.length() - 2);
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)sb.toString()), false);
            return 1;
        })))));
    }

    private static void loadConfig(class_2168 source) {
        try {
            String content;
            if (configPath == null) {
                Path worldDir = source.method_9211().method_27050(class_5218.field_24188);
                configPath = worldDir.resolve("allowed_flight.txt");
            }
            allowedFlightDimensions.clear();
            if (Files.exists(configPath, new LinkOption[0]) && !(content = Files.readString(configPath).trim()).isEmpty()) {
                String[] parts;
                for (String part : parts = content.split(",")) {
                    class_2960 id = class_2960.method_12829((String)part.trim());
                    if (id == null) continue;
                    class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
                    allowedFlightDimensions.add((class_5321<class_1937>)key);
                }
            }
            source.method_9226(() -> class_2561.method_43470((String)"Flight config reloaded."), false);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config", (Throwable)e);
            source.method_9213((class_2561)class_2561.method_43470((String)"Error loading config."));
        }
    }

    public static void loadConfig(Path path) {
        allowedFlightDimensions.clear();
        configPath = path;
        LOGGER.info("Loading config from: {}", (Object)path.toString());
        try {
            String content;
            if (Files.exists(configPath, new LinkOption[0]) && !(content = Files.readString(configPath).trim()).isEmpty()) {
                String[] parts;
                for (String part : parts = content.split(",")) {
                    class_2960 id = class_2960.method_12829((String)part.trim());
                    if (id == null) continue;
                    class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
                    allowedFlightDimensions.add((class_5321<class_1937>)key);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config", (Throwable)e);
        }
    }

    private static void saveConfig(class_2168 source) {
        try {
            if (configPath == null) {
                Path worldDir = source.method_9211().method_27050(class_5218.field_24188);
                configPath = worldDir.resolve("allowed_flight.txt");
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (class_5321<class_1937> key : allowedFlightDimensions) {
                ids.add(key.method_29177().toString());
            }
            Files.writeString(configPath, (CharSequence)String.join((CharSequence)",", ids), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            source.method_9226(() -> class_2561.method_43470((String)"Config saved."), false);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
            source.method_9213((class_2561)class_2561.method_43470((String)"Error saving config."));
        }
    }

    static {
        DIMENSION_SUGGESTIONS = (context, builder) -> class_2172.method_9257(((class_2168)context.getSource()).method_9211().method_29435().stream().map(class_5321::method_29177), (SuggestionsBuilder)builder);
    }
}

