#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;

out vec4 fragColor;

void main() {
	vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    if (color.a < 0.1) {
        discard;
    }
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
	
	
	// Cape shenanigans
	vec2 texSize = textureSize(Sampler0,0);
	vec4 preColor = texture(Sampler0, texCoord0);
	
	// Using code for detecting capes from https://github.com/McTsts/mc-core-shaders
	if (texSize.x == 64 && texSize.y == 32 && // check if size matches a cape
			texture(Sampler0, vec2(0.0, 1.0/32.0)).a == 1.0 && texture(Sampler0, vec2(12.0/64.0, 16.0/32.0)).a == 1.0 && // check if skin transparent pixels have color
			(	// support both types of cape texture
				(texture(Sampler0, vec2(0.0, 18.0/32.0)) == vec4(1.0) && texture(Sampler0, vec2(0.99, 0.99)) == vec4(1.0) && texture(Sampler0, vec2(0.99, 0.0)) == vec4(1.0)) // for capes filled with white, check for white pixels
				|| (texture(Sampler0, vec2(25.0/64.0, 25.0/32.0)).a == 0.0 || texture(Sampler0, vec2(30.0/64.0, 10.0/32.0)).a == 0.0 || texture(Sampler0, vec2(9.0/64.0, 25.0/32.0)).a == 0.0)  // otherwise check of transparent pixels
			)
	){
		if (texture(Sampler0, vec2(40.0/64.0, 7.0/32.0)).rgb == vec3(38, 26, 22)/255. && texture(Sampler0, vec2(39.0/64.0, 8.0/32.0)).rgb == vec3(38, 26, 22)/255. && texture(Sampler0, vec2(40.0/64.0, 9.0/32.0)).rgb == vec3(232, 150, 106)/255.) {
			vec3 fillColor = texture(Sampler0, vec2(37.0/64.0, 6.0/32.0)).rgb;
			if (preColor.rgb == vec3(38, 26, 22)/255. || preColor.rgb == vec3(49, 37, 30)/255. || preColor.rgb == vec3(68, 48, 39)/255. || preColor.rgb == vec3(232, 150, 106)/255. || preColor.rgb == vec3(243, 175, 138)/255. || preColor.rgb == vec3(255, 200, 163)/255. || preColor.rgb == vec3(81, 50, 27)/255. || preColor.rgb == vec3(89, 82, 79)/255. || preColor.rgb == vec3(169, 161, 156)/255. || preColor.rgb == vec3(138, 127, 120)/255. || preColor.rgb == vec3(74, 63, 58)/255. || preColor.rgb == vec3(115, 104, 101)/255. || preColor.rgb == vec3(159, 151, 146)/255. || preColor.rgb == vec3(1.0) || preColor.rgb == vec3(34, 166, 212)/255. || preColor.rgb == vec3(0, 132, 161)/255. || preColor.rgb == vec3(71, 200, 253)/255. || preColor.rgb == vec3(68, 209, 240)/255.) {
				preColor.rgb = fillColor;
			}
			fragColor = linear_fog(preColor * vertexColor * ColorModulator, vertexDistance, FogStart, FogEnd, FogColor);
		}
	}
}
