/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.DataMapHooks;
import net.tier1234.better_deco.block.ModBlocks;

public interface WeatheringBlocksCustom
extends ChangeOverTimeBlock<WeatheringCopper.WeatherState> {
    @Deprecated
    public static final Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)ModBlocks.COPPER_LANTERN.get()), (Object)((Block)ModBlocks.EXPOSED_LANTERN.get())).put((Object)((Block)ModBlocks.EXPOSED_LANTERN.get()), (Object)((Block)ModBlocks.WEATHERED_LANTERN.get())).put((Object)((Block)ModBlocks.WEATHERED_LANTERN.get()), (Object)((Block)ModBlocks.OXIDIZED_LANTERN.get())).build());
    @Deprecated
    public static final Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());

    public static Optional<Block> getPrevious(Block block) {
        return Optional.ofNullable(DataMapHooks.getPreviousOxidizedStage((Block)block));
    }

    public static Block getFirst(Block p_block) {
        Block block = p_block;
        Block block1 = DataMapHooks.getPreviousOxidizedStage((Block)p_block);
        while (block1 != null) {
            block = block1;
            block1 = DataMapHooks.getPreviousOxidizedStage((Block)block1);
        }
        return block;
    }

    public static Optional<BlockState> getPrevious(BlockState state) {
        return WeatheringBlocksCustom.getPrevious(state.getBlock()).map(p_154903_ -> p_154903_.withPropertiesOf(state));
    }

    public static Optional<Block> getNext(Block block) {
        return Optional.ofNullable(DataMapHooks.getNextOxidizedStage((Block)block));
    }

    public static BlockState getFirst(BlockState state) {
        return WeatheringBlocksCustom.getFirst(state.getBlock()).withPropertiesOf(state);
    }

    default public Optional<BlockState> getNext(BlockState state) {
        return WeatheringBlocksCustom.getNext(state.getBlock()).map(p_154896_ -> p_154896_.withPropertiesOf(state));
    }

    default public float getChanceModifier() {
        return this.getAge() == WeatheringCopper.WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }

    public static enum WeatherState implements StringRepresentable
    {
        UNAFFECTED("unaffected"),
        EXPOSED("exposed"),
        WEATHERED("weathered"),
        OXIDIZED("oxidized");

        public static final Codec<WeatheringCopper.WeatherState> CODEC;
        private final String name;

        private WeatherState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(WeatheringCopper.WeatherState::values);
        }
    }
}

