/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.core;

import java.util.Iterator;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.tier1234.better_deco.block.entity.core.BasicContainerOpenersCounter;
import org.jetbrains.annotations.Nullable;

public abstract class BasicLootBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private final int[] slots;
    protected NonNullList<ItemStack> items;
    protected final ContainerOpenersCounter openersCounter = new BasicContainerOpenersCounter(this);

    public BasicLootBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.slots = IntStream.range(0, this.getContainerSize()).toArray();
    }

    public abstract int getContainerSize();

    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        ChestMenu chestMenu;
        return menu instanceof ChestMenu && (chestMenu = (ChestMenu)menu).getContainer() == this;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected abstract Component getDefaultName();

    protected boolean addItem(ItemStack stack) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (!this.getItem(i).isEmpty()) continue;
            this.setItem(i, stack);
            return true;
        }
        return false;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    public boolean isEmpty() {
        ItemStack stack;
        Iterator it = this.items.iterator();
        do {
            if (it.hasNext()) continue;
            return true;
        } while ((stack = (ItemStack)it.next()).isEmpty());
        return false;
    }

    public boolean isFull() {
        for (ItemStack stack : this.items) {
            if (!stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (!this.trySaveLootTable(output)) {
            ContainerHelper.saveAllItems((ValueOutput)output, this.items);
        }
    }

    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(input)) {
            ContainerHelper.loadAllItems((ValueInput)input, this.items);
        }
    }

    public int[] getSlotsForFace(Direction direction) {
        return this.slots;
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return true;
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return true;
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void updateOpenerCount() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void onOpen(Level level, BlockPos pos, BlockState state) {
    }

    public void onClose(Level level, BlockPos pos, BlockState state) {
    }
}

