/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.tier1234.better_deco.block.entity.ModBlockEntities;
import org.jetbrains.annotations.Nullable;

public class DigitalClockBlockEntity
extends BlockEntity {
    private DyeColor textColor = DyeColor.WHITE;

    public DigitalClockBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.DIGITAL_CLOCK.get(), pos, state);
    }

    public void setTextColor(DyeColor color) {
        this.textColor = color;
        this.sync();
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public void sync() {
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static String getFormattedTime(long ticks) {
        int hours = (int)((Math.floor((double)ticks / 1000.0) + 6.0) % 24.0);
        int minutes = (int)Math.floor((double)(ticks % 1000L) / 1000.0 * 60.0);
        return String.format("%02d:%02d", hours, minutes);
    }

    public static int getFromColor(DyeColor color) {
        return switch (color) {
            case DyeColor.ORANGE -> -23296;
            case DyeColor.MAGENTA -> -65281;
            case DyeColor.LIGHT_BLUE -> -11141121;
            case DyeColor.YELLOW -> -171;
            case DyeColor.LIME -> -11141291;
            case DyeColor.PINK -> -43521;
            case DyeColor.GRAY -> -11184811;
            case DyeColor.LIGHT_GRAY -> -5592406;
            case DyeColor.CYAN -> -16733526;
            case DyeColor.PURPLE -> -5635926;
            case DyeColor.BLUE -> -16777046;
            case DyeColor.BROWN -> -5614336;
            case DyeColor.GREEN -> -16733696;
            case DyeColor.RED -> -5636096;
            case DyeColor.BLACK -> -16777216;
            default -> -1;
        };
    }
}

