/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.tier1234.better_deco.block.custom.DigitalClockBlock;
import net.tier1234.better_deco.block.entity.custom.DigitalClockBlockEntity;
import org.joml.Quaternionfc;

public class DigitalClockBlockEntityRenderer
implements BlockEntityRenderer<DigitalClockBlockEntity> {
    private final Font font;

    public DigitalClockBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
    }

    public void render(DigitalClockBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, Vec3 vec3) {
        BlockState state = blockEntity.getBlockState();
        if (!(state.getBlock() instanceof DigitalClockBlock)) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        int rotation = ((Direction)state.getValue((Property)DigitalClockBlock.DIRECTION)).get2DDataValue();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f * (float)rotation + 180.0f));
        poseStack.translate(0.0675, 0.005, -0.032);
        poseStack.translate(-0.2625, -0.3125, 0.096875);
        poseStack.scale(0.010416667f, -0.010416667f, 0.010416667f);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        String timeText = DigitalClockBlockEntity.getFormattedTime(Minecraft.getInstance().level.getDayTime());
        int color = DigitalClockBlockEntity.getFromColor(blockEntity.getTextColor());
        this.font.drawInBatch(timeText, 0.0f, 0.0f, color, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.popPose();
    }
}

