/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.compat.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.tier1234.better_deco.compat.jei.category.MicrowaveRecipeCategory;
import net.tier1234.better_deco.compat.jei.category.OvenRecipeCategory;
import net.tier1234.better_deco.event.ModRecipeReceived;
import net.tier1234.better_deco.recipe.ModRecipes;
import net.tier1234.better_deco.screen.custom.MicrowaveScreen;
import net.tier1234.better_deco.screen.custom.OvenScreen;

@JeiPlugin
public class BetterDecoJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"better_deco", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new OvenRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MicrowaveRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List ovenRecipes = ModRecipeReceived.recipeMap.byType((RecipeType)ModRecipes.OVEN_TYPE.get()).stream().toList();
        registration.addRecipes(OvenRecipeCategory.OVEN_TYPE, ovenRecipes);
        List microwaveRecipes = ModRecipeReceived.recipeMap.byType((RecipeType)ModRecipes.MICROWAVE_TYPE.get()).stream().toList();
        registration.addRecipes(MicrowaveRecipeCategory.MICROWAVE_TYPE, microwaveRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(OvenScreen.class, 74, 30, 22, 20, new IRecipeType[]{OvenRecipeCategory.OVEN_TYPE});
        registration.addRecipeClickArea(MicrowaveScreen.class, 74, 30, 22, 20, new IRecipeType[]{MicrowaveRecipeCategory.MICROWAVE_TYPE});
    }
}

