/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.entity.ModEntities;
import net.tier1234.better_deco.util.VoxelShapeHelper;
import org.jetbrains.annotations.Nullable;

public class BarStoolBlock
extends Block {
    public static final DirectionProperty DIRECTION = DirectionProperty.create((String)"direction", (Predicate)Direction.Plane.HORIZONTAL);
    public static final IntegerProperty COLOUR = IntegerProperty.create((String)"colour", (int)0, (int)15);
    private final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public BarStoolBlock(BlockBehaviour.Properties properties) {
        super(BlockBehaviour.Properties.of().strength(0.5f).sound(SoundType.WOOD).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.stateDefinition.getPossibleStates());
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.box((double)2.0, (double)0.0, (double)2.0, (double)13.0, (double)9.0, (double)13.0);
        VoxelShape legFrontLeft = Block.box((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)13.0, (double)4.0);
        VoxelShape legFrontRight = Block.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)4.0);
        VoxelShape legBackLeft = Block.box((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)13.0, (double)14.0);
        VoxelShape legBackRight = Block.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)13.0, (double)14.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(baseShape);
            shapes.add(legFrontLeft);
            shapes.add(legFrontRight);
            shapes.add(legBackLeft);
            shapes.add(legBackRight);
            VoxelShape combined = VoxelShapeHelper.combineAll(shapes);
            VoxelShape rotated = VoxelShapeHelper.rotate(combined, dir);
            builder.put((Object)state, (Object)rotated);
        }
        return builder.build();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DIRECTION, COLOUR});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Entity entity = null;
            List entities = level.getEntities((EntityTypeTest)ModEntities.CHAIR_ENTITY.get(), new AABB(pos), chair -> true);
            entity = entities.isEmpty() ? ModEntities.CHAIR_ENTITY.get().spawn((ServerLevel)level, pos, MobSpawnType.TRIGGERED) : (Entity)entities.get(0);
            player.startRiding(entity);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction dir = context.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)dir);
    }
}

