/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class DeskBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    private final MaterialType materialType;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public DeskBlock(BlockBehaviour.Properties properties, MaterialType materialType) {
        super(properties);
        this.materialType = materialType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)Type.SINGLE)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] DESK_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] DESK_BACK = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] DESK_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] DESK_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            Type type = (Type)((Object)state.getValue(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(DESK_TOP[direction.get2DDataValue()]);
            shapes.add(DESK_BACK[direction.get2DDataValue()]);
            switch (type.ordinal()) {
                case 0: {
                    shapes.add(DESK_LEFT[direction.get2DDataValue()]);
                    shapes.add(DESK_RIGHT[direction.get2DDataValue()]);
                    break;
                }
                case 1: {
                    shapes.add(DESK_LEFT[direction.get2DDataValue()]);
                    break;
                }
                case 2: {
                    shapes.add(DESK_RIGHT[direction.get2DDataValue()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        Direction dir = (Direction)state.getValue((Property)DIRECTION);
        boolean left = this.isDesk(level, pos, dir.getCounterClockWise(), dir);
        boolean right = this.isDesk(level, pos, dir.getClockWise(), dir);
        if (left && right) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isDesk(LevelAccessor level, BlockPos source, Direction checkDirection, Direction tableDirection) {
        BlockState state = level.getBlockState(source.relative(checkDirection));
        return state.getBlock() instanceof DeskBlock && ((DeskBlock)state.getBlock()).materialType == this.materialType && state.getValue((Property)DIRECTION) == tableDirection;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    public static enum MaterialType {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        MANGROVE,
        CHERRY,
        BAMBOO,
        CRIMSON,
        WARPED;

    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String getSerializedName() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

