/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.custom.DeskBlock;
import net.tier1234.better_deco.block.entity.core.BasicLootBlockEntity;
import net.tier1234.better_deco.block.entity.custom.DeskCabinetBlockEntity;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class DeskCabinetBlock
extends DeskBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");

    public DeskCabinetBlock(BlockBehaviour.Properties properties, DeskBlock.MaterialType materialType) {
        super(properties, materialType);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)TYPE, (Comparable)((Object)DeskBlock.Type.SINGLE))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] DESK_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] DESK_BACK = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] DESK_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] DESK_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] DESK_DRAWS = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)15.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            DeskBlock.Type type = (DeskBlock.Type)((Object)state.getValue((Property)TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(DESK_TOP[direction.get2DDataValue()]);
            shapes.add(DESK_BACK[direction.get2DDataValue()]);
            shapes.add(DESK_DRAWS[direction.get2DDataValue()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(DESK_LEFT[direction.get2DDataValue()]);
                    shapes.add(DESK_RIGHT[direction.get2DDataValue()]);
                    break;
                }
                case LEFT: {
                    shapes.add(DESK_LEFT[direction.get2DDataValue()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(DESK_RIGHT[direction.get2DDataValue()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (((Direction)state.getValue((Property)DIRECTION)).getOpposite() == result.getDirection()) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof DeskCabinetBlockEntity) {
                DeskCabinetBlockEntity blockEntity2 = (DeskCabinetBlockEntity)blockEntity;
                player.openMenu((MenuProvider)blockEntity2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity blockEntity2 = (BasicLootBlockEntity)blockEntity;
            blockEntity2.updateOpenerCount();
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPEN});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DeskCabinetBlockEntity(pos, state);
    }
}

