/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.tier1234.better_deco.block.custom.FridgeBlock;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.block.entity.ModBlockEntities;
import net.tier1234.better_deco.block.entity.core.BasicLootBlockEntity;
import net.tier1234.better_deco.block.entity.custom.FreezerBlockEntity;
import net.tier1234.better_deco.util.VoxelShapeHelper;
import org.jetbrains.annotations.Nullable;

public class FreezerBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    public final Supplier<DeferredBlock<Block>> fridge;

    public FreezerBlock(BlockBehaviour.Properties properties, Supplier<DeferredBlock<Block>> fridge) {
        super(properties);
        this.fridge = fridge;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] DOOR = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)13.0, (double)1.0, (double)13.0, (double)16.0, (double)16.0, (double)29.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            boolean open = (Boolean)state.getValue((Property)OPEN);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(Block.box((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0));
            if (open) {
                shapes.add(BASE[direction.get2DDataValue()]);
                shapes.add(DOOR[direction.get2DDataValue()]);
            } else {
                shapes.add(Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return context == CollisionContext.empty() ? Shapes.block() : (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        BlockEntity entity;
        if (((Direction)state.getValue((Property)DIRECTION)).getOpposite() == result.getDirection() && !level.isClientSide() && (entity = level.getBlockEntity(pos)) instanceof FreezerBlockEntity) {
            FreezerBlockEntity freezerBlockEntity = (FreezerBlockEntity)entity;
            ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)freezerBlockEntity, (Component)Component.translatable((String)"gui.better_deco.freezer")), pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity blockEntity2 = (BasicLootBlockEntity)blockEntity;
            blockEntity2.updateOpenerCount();
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPEN});
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.getBlockState(pos.above()).isAir();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.setBlockAndUpdate(pos.above(), (BlockState)((Block)this.fridge.get().get()).defaultBlockState().setValue((Property)DIRECTION, (Comparable)placer.getDirection()));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState upState = level.getBlockState(pos.above());
        if (upState.getBlock() instanceof FridgeBlock) {
            level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, pos.above(), Block.getId((BlockState)upState));
        }
        super.playerWillDestroy(level, pos, state, player);
        return upState;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FreezerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : (type == ModBlockEntities.FREEZER.get() ? (lvl, pos, st, be) -> {
            FreezerBlockEntity cfr_ignored_0 = (FreezerBlockEntity)be;
            FreezerBlockEntity.tick(lvl, pos, st, (FreezerBlockEntity)be);
        } : null);
    }

    public Item asItem() {
        return ((Block)this.fridge.get().get()).asItem();
    }
}

