/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.entity.ModEntities;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class ParkBenchBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ParkBenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)Type.SINGLE)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] SEAT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)8.0, (double)3.0, (double)16.0, (double)9.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] BACKREST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)9.0, (double)1.0, (double)16.0, (double)20.0, (double)5.0), Direction.SOUTH));
        VoxelShape[] BACK_LEFT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)1.0, (double)0.0, (double)3.0, (double)4.0, (double)8.0, (double)6.0), Direction.SOUTH));
        VoxelShape[] FRONT_LEFT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] FRONT_RIGHT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] BACK_RIGHT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)12.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)6.0), Direction.SOUTH));
        VoxelShape[] LEFT_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)1.0, (double)6.0, (double)6.0, (double)4.0, (double)8.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] RIGHT_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)12.0, (double)6.0, (double)6.0, (double)15.0, (double)8.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] FRONT_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)1.0, (double)6.0, (double)12.0, (double)15.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] BACK_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)1.0, (double)6.0, (double)3.0, (double)15.0, (double)8.0, (double)6.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            Type type = (Type)((Object)state.getValue(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(SEAT[direction.get2DDataValue()]);
            shapes.add(BACKREST[direction.get2DDataValue()]);
            shapes.add(FRONT_SUPPORT[direction.get2DDataValue()]);
            shapes.add(BACK_SUPPORT[direction.get2DDataValue()]);
            switch (type.ordinal()) {
                case 0: {
                    shapes.add(BACK_LEFT_LEG[direction.get2DDataValue()]);
                    shapes.add(FRONT_LEFT_LEG[direction.get2DDataValue()]);
                    shapes.add(FRONT_RIGHT_LEG[direction.get2DDataValue()]);
                    shapes.add(BACK_RIGHT_LEG[direction.get2DDataValue()]);
                    shapes.add(LEFT_SUPPORT[direction.get2DDataValue()]);
                    shapes.add(RIGHT_SUPPORT[direction.get2DDataValue()]);
                    break;
                }
                case 1: {
                    shapes.add(BACK_LEFT_LEG[direction.get2DDataValue()]);
                    shapes.add(FRONT_LEFT_LEG[direction.get2DDataValue()]);
                    shapes.add(LEFT_SUPPORT[direction.get2DDataValue()]);
                    break;
                }
                case 2: {
                    shapes.add(FRONT_RIGHT_LEG[direction.get2DDataValue()]);
                    shapes.add(BACK_RIGHT_LEG[direction.get2DDataValue()]);
                    shapes.add(RIGHT_SUPPORT[direction.get2DDataValue()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Entity entity = null;
            List entities = level.getEntities((EntityTypeTest)ModEntities.CHAIR_ENTITY.get(), new AABB(pos), chair -> true);
            entity = entities.isEmpty() ? ModEntities.CHAIR_ENTITY.get().spawn((ServerLevel)level, pos, MobSpawnType.TRIGGERED) : (Entity)entities.get(0);
            player.startRiding(entity);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return this.getBenchState(state, (LevelAccessor)context.getLevel(), context.getClickedPos(), (Direction)state.getValue((Property)DIRECTION));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getBenchState(state, level, pos, (Direction)state.getValue((Property)DIRECTION));
    }

    private BlockState getBenchState(BlockState state, LevelAccessor level, BlockPos pos, Direction dir) {
        boolean left = this.isBench(level, pos, dir.getCounterClockWise(), dir);
        boolean right = this.isBench(level, pos, dir.getClockWise(), dir);
        if (left && right) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isBench(LevelAccessor level, BlockPos source, Direction direction, Direction targetDirection) {
        BlockState state = level.getBlockState(source.relative(direction));
        if (state.getBlock() == this) {
            Direction sofaDirection = (Direction)state.getValue((Property)DIRECTION);
            return sofaDirection.equals((Object)targetDirection);
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String getSerializedName() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

