/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.entity.ModEntities;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class SofaBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)Type.SINGLE)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape BASE = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape[] LEG_BACK_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] LEG_FRONT_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] LEG_FRONT_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] LEG_BACK_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] BACK_REST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)20.0, (double)4.0), Direction.SOUTH));
        VoxelShape[] BACK_REST_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)10.0, (double)4.0, (double)4.0, (double)20.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] BACK_REST_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)12.0, (double)10.0, (double)4.0, (double)16.0, (double)20.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] LEFT_ARM_REST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)-2.0, (double)9.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] RIGHT_ARM_REST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)14.0, (double)9.0, (double)1.0, (double)18.0, (double)14.0, (double)16.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            Type type = (Type)((Object)state.getValue(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(BASE);
            shapes.add(BACK_REST[direction.get2DDataValue()]);
            switch (type.ordinal()) {
                case 0: {
                    shapes.add(LEG_BACK_LEFT[direction.get2DDataValue()]);
                    shapes.add(LEG_FRONT_LEFT[direction.get2DDataValue()]);
                    shapes.add(LEG_FRONT_RIGHT[direction.get2DDataValue()]);
                    shapes.add(LEG_BACK_RIGHT[direction.get2DDataValue()]);
                    shapes.add(LEFT_ARM_REST[direction.get2DDataValue()]);
                    shapes.add(RIGHT_ARM_REST[direction.get2DDataValue()]);
                    break;
                }
                case 1: {
                    shapes.add(LEG_BACK_LEFT[direction.get2DDataValue()]);
                    shapes.add(LEG_FRONT_LEFT[direction.get2DDataValue()]);
                    shapes.add(LEFT_ARM_REST[direction.get2DDataValue()]);
                    break;
                }
                case 2: {
                    shapes.add(LEG_FRONT_RIGHT[direction.get2DDataValue()]);
                    shapes.add(LEG_BACK_RIGHT[direction.get2DDataValue()]);
                    shapes.add(RIGHT_ARM_REST[direction.get2DDataValue()]);
                    break;
                }
                case 4: {
                    shapes.add(LEG_BACK_LEFT[direction.get2DDataValue()]);
                    shapes.add(BACK_REST_LEFT[direction.get2DDataValue()]);
                    break;
                }
                case 5: {
                    shapes.add(LEG_BACK_RIGHT[direction.get2DDataValue()]);
                    shapes.add(BACK_REST_RIGHT[direction.get2DDataValue()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return this.getSofaState(state, (LevelAccessor)context.getLevel(), context.getClickedPos(), (Direction)state.getValue((Property)DIRECTION));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            List entities = level.getEntities((EntityTypeTest)ModEntities.CHAIR_ENTITY.get(), new AABB(pos), chair -> true);
            Entity entity = entities.isEmpty() ? ModEntities.CHAIR_ENTITY.get().spawn((ServerLevel)level, pos, MobSpawnType.TRIGGERED) : (Entity)entities.get(0);
            player.startRiding(entity);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getSofaState(state, level, pos, (Direction)state.getValue((Property)DIRECTION));
    }

    private BlockState getSofaState(BlockState state, LevelAccessor level, BlockPos pos, Direction dir) {
        boolean left = this.isSofa(level, pos, dir.getCounterClockWise(), dir) || this.isSofa(level, pos, dir.getCounterClockWise(), dir.getCounterClockWise());
        boolean right = this.isSofa(level, pos, dir.getClockWise(), dir) || this.isSofa(level, pos, dir.getClockWise(), dir.getClockWise());
        boolean cornerLeft = this.isSofa(level, pos, dir.getOpposite(), dir.getCounterClockWise());
        boolean cornerRight = this.isSofa(level, pos, dir.getOpposite(), dir.getClockWise());
        if (cornerLeft) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.CORNER_LEFT));
        }
        if (cornerRight) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.CORNER_RIGHT));
        }
        if (left && right) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isSofa(LevelAccessor level, BlockPos source, Direction direction, Direction targetDirection) {
        BlockState state = level.getBlockState(source.relative(direction));
        if (state.getBlock() == this) {
            Direction sofaDirection = (Direction)state.getValue((Property)DIRECTION);
            return sofaDirection.equals((Object)targetDirection);
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String getSerializedName() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

