/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class TableBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape TABLE_TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape MIDDLE_POST = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
        VoxelShape END_POST = Block.box((double)3.0, (double)0.0, (double)6.0, (double)7.0, (double)14.0, (double)10.0);
        VoxelShape CORNER_POST = Block.box((double)3.0, (double)0.0, (double)9.0, (double)7.0, (double)14.0, (double)13.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.getValue((Property)NORTH);
            boolean east = (Boolean)state.getValue((Property)EAST);
            boolean south = (Boolean)state.getValue((Property)SOUTH);
            boolean west = (Boolean)state.getValue((Property)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TABLE_TOP);
            if (!north & !east && !south && !west) {
                shapes.add(MIDDLE_POST);
            } else if (north & !east && !south && !west) {
                shapes.add(VoxelShapeHelper.rotate(END_POST, Direction.NORTH));
            } else if (!north & east && !south && !west) {
                shapes.add(VoxelShapeHelper.rotate(END_POST, Direction.EAST));
            } else if (!north & !east && south && !west) {
                shapes.add(VoxelShapeHelper.rotate(END_POST, Direction.SOUTH));
            } else if (!north & !east && !south && west) {
                shapes.add(VoxelShapeHelper.rotate(END_POST, Direction.WEST));
            } else if (north && east && !south && !west) {
                shapes.add(VoxelShapeHelper.rotate(CORNER_POST, Direction.EAST));
            } else if (!north && east && south && !west) {
                shapes.add(VoxelShapeHelper.rotate(CORNER_POST, Direction.SOUTH));
            } else if (!north && !east && south && west) {
                shapes.add(VoxelShapeHelper.rotate(CORNER_POST, Direction.WEST));
            } else if (north && !east && !south && west) {
                shapes.add(VoxelShapeHelper.rotate(CORNER_POST, Direction.NORTH));
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = level.getBlockState(pos.north()).getBlock() == this;
        boolean east = level.getBlockState(pos.east()).getBlock() == this;
        boolean south = level.getBlockState(pos.south()).getBlock() == this;
        boolean west = level.getBlockState(pos.west()).getBlock() == this;
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH});
        builder.add(new Property[]{EAST});
        builder.add(new Property[]{SOUTH});
        builder.add(new Property[]{WEST});
    }
}

