/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class ToasterBlock
extends FurnitureHorizontalBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ToasterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape BODY = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)11.0);
        VoxelShape LEVER_LEFT = Block.box((double)5.0, (double)0.0, (double)4.0, (double)6.0, (double)1.0, (double)10.0);
        VoxelShape LEVER_RIGHT = Block.box((double)10.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)10.0);
        VoxelShape SIDE_LEFT = Block.box((double)4.0, (double)1.0, (double)3.5, (double)5.0, (double)7.0, (double)10.5);
        VoxelShape SIDE_RIGHT = Block.box((double)11.0, (double)1.0, (double)3.5, (double)12.0, (double)7.0, (double)10.5);
        VoxelShape BASE_SHAPE = VoxelShapeHelper.combineAll(List.of(BODY, LEVER_LEFT, LEVER_RIGHT, SIDE_LEFT, SIDE_RIGHT));
        VoxelShape[] ROTATED = VoxelShapeHelper.getRotatedShapes(BASE_SHAPE);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)DIRECTION);
            builder.put((Object)state, (Object)ROTATED[dir.get2DDataValue()]);
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return state;
    }
}

