/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.tier1234.better_deco.block.custom.FridgeBlock;
import net.tier1234.better_deco.block.entity.ModBlockEntities;
import net.tier1234.better_deco.block.entity.core.BasicLootBlockEntity;

public class FridgeBlockEntity
extends BasicLootBlockEntity {
    protected FridgeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public FridgeBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FRIDGE.get(), pos, state);
    }

    @Override
    public int getContainerSize() {
        return 45;
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"gui.better_deco.fridge");
    }

    @Override
    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return new ChestMenu(MenuType.GENERIC_9x5, windowId, playerInventory, (Container)this, 5);
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        this.playDoorSound(state, SoundEvents.UI_LOOM_SELECT_PATTERN);
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        this.playDoorSound(state, SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT);
        this.setDoorState(state, false);
    }

    private void playDoorSound(BlockState state, SoundEvent event) {
        Vec3i directionVec = ((Direction)state.getValue((Property)FridgeBlock.DIRECTION)).getOpposite().getNormal();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)directionVec.getX() / 2.0;
        double y = (double)this.worldPosition.getY() + 0.5 + (double)directionVec.getY() / 2.0;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)directionVec.getZ() / 2.0;
        Level level = this.getLevel();
        if (level != null) {
            level.playSound(null, x, y, z, event, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.getLevel();
        if (level != null) {
            level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)FridgeBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }
}

