/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.tier1234.better_deco.block.ModBlocks;
import net.tier1234.better_deco.recipe.MicrowaveRecipe;
import org.jetbrains.annotations.Nullable;

public class MicrowaveRecipeCategory
implements IRecipeCategory<MicrowaveRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"better_deco", (String)"microwave");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"better_deco", (String)"textures/gui/microwave/growth_chamber_gui_jei.png");
    public static final RecipeType<MicrowaveRecipe> MICROWAVE_RECIPE_RECIPE_TYPE = new RecipeType(UID, MicrowaveRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public MicrowaveRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModBlocks.LIGHT_MICROWAVE));
    }

    public RecipeType<MicrowaveRecipe> getRecipeType() {
        return MICROWAVE_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.better_deco.microwave");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MicrowaveRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 54, 34).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 104, 34).addItemStack(recipe.getResultItem(null));
    }
}

