/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.creative_tabs;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.tier1234.better_deco.creative_tabs.BundledTabSelector;
import org.jetbrains.annotations.Nullable;

public class BundledTabs {
    public final Component tooltip;
    private final ItemStack icon;
    private final List<ItemStack> displayItems;
    @Nullable
    private BundledTabSelector.Tab tab;
    private boolean selected = false;

    private BundledTabs(Component tooltip, ItemStack icon, List<ItemStack> displayItems) {
        this.tooltip = tooltip;
        this.icon = icon;
        this.displayItems = displayItems;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public boolean contains(ItemStack stack) {
        return this.displayItems.contains(stack);
    }

    public List<ItemStack> getDisplayItems() {
        return this.displayItems;
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setContentTab(@Nullable BundledTabSelector.Tab tab) {
        this.tab = tab;
    }

    public void setVisible(boolean visible) {
        if (this.tab != null) {
            this.tab.visible = visible;
        }
    }

    public void setY(int y) {
        if (this.tab != null) {
            this.tab.setY(y);
        }
    }

    public static class Builder {
        private Component title;
        private ItemStack icon;
        private final List<ItemStack> displayItems = new ArrayList<ItemStack>();

        public Builder title(Component title) {
            this.title = title;
            return this;
        }

        public Builder icon(ItemStack icon) {
            this.icon = icon;
            return this;
        }

        public Builder displayItems(BiConsumer<HolderLookup.Provider, Output> consumer) {
            Optional<MinecraftServer> server = Optional.ofNullable(ServerLifecycleHooks.getCurrentServer());
            assert (server.isPresent());
            RegistryAccess.Frozen provider = server.get().registryAccess();
            Output output = new Output(){

                @Override
                public void accept(ItemLike item) {
                    displayItems.add(new ItemStack(item));
                }

                @Override
                public void accept(ItemStack stack) {
                    displayItems.add(stack);
                }
            };
            consumer.accept((HolderLookup.Provider)provider, output);
            return this;
        }

        public BundledTabs build() {
            if (this.title == null) {
                this.title = Component.empty();
            }
            if (this.icon == null) {
                this.icon = ItemStack.EMPTY;
            }
            return new BundledTabs(this.title, this.icon, new ArrayList<ItemStack>(this.displayItems));
        }
    }

    public static interface Output {
        public void accept(ItemLike var1);

        public void accept(ItemStack var1);
    }
}

