/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.tier1234.better_deco.BetterDeco;
import net.tier1234.better_deco.block.ModBlocks;
import net.tier1234.better_deco.block.custom.VerticalSlabBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "better_deco", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.OAK_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/oak_planks"), BetterDeco.id("block/oak_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.SPRUCE_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/spruce_planks"), BetterDeco.id("block/spruce_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.BIRCH_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/birch_planks"), BetterDeco.id("block/birch_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.JUNGLE_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/jungle_planks"), BetterDeco.id("block/jungle_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.ACACIA_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/acacia_planks"), BetterDeco.id("block/acacia_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.DARK_OAK_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/dark_oak_planks"), BetterDeco.id("block/dark_oak_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.MANGROVE_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/mangrove_planks"), BetterDeco.id("block/mangrove_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.CHERRY_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/cherry_planks"), BetterDeco.id("block/cherry_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.BAMBOO_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/bamboo_planks"), BetterDeco.id("block/bamboo_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.CRIMSON_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/crimson_planks"), BetterDeco.id("block/crimson_vertical_slab", new Object[0]));
        this.createVerticalSlab((VerticalSlabBlock)((Object)ModBlocks.WARPED_VERTICAL_SLAB.get()), ResourceLocation.parse((String)"block/warped_planks"), BetterDeco.id("block/warped_vertical_slab", new Object[0]));
    }

    public void createVerticalSlab(VerticalSlabBlock block, ResourceLocation doubleFile, ResourceLocation slabFile) {
        this.createVerticalSlab(block, (ModelFile)new ModelFile.ExistingModelFile(doubleFile, this.models().existingFileHelper), (ModelFile)new ModelFile.ExistingModelFile(slabFile, this.models().existingFileHelper));
    }

    public void createVerticalSlab(VerticalSlabBlock block, ModelFile doubleFile, ModelFile slabFile) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            if (state.getValue((Property)VerticalSlabBlock.TYPE) == SlabType.DOUBLE) {
                return ConfiguredModel.builder().modelFile(doubleFile).build();
            }
            return ConfiguredModel.builder().modelFile(slabFile).rotationY(((int)VerticalSlabBlock.toDirection(state).toYRot() + 180) % 360).build();
        });
    }
}

