/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tier1234.better_deco.block.ModBlocks;
import net.tier1234.better_deco.recipe.FreezerRecipeInput;
import net.tier1234.better_deco.recipe.ModRecipes;

public record FreezerRecipe(ResourceLocation id, Ingredient input, ItemStack output, int freezeTime, float experience) implements Recipe<FreezerRecipeInput>
{
    public boolean matches(FreezerRecipeInput container, Level level) {
        return this.input.test(container.getInput());
    }

    public ItemStack assemble(FreezerRecipeInput container, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getFreezeTime() {
        return this.freezeTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.FREEZER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.FREEZER_TYPE.get();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.FRIDGE_LIGHT.get());
    }

    public static class Serializer
    implements RecipeSerializer<FreezerRecipe> {
        public static final MapCodec<FreezerRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FreezerRecipe::getId), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(FreezerRecipe::input), (App)ItemStack.CODEC.fieldOf("result").forGetter(FreezerRecipe::output), (App)Codec.INT.fieldOf("cookingtime").forGetter(FreezerRecipe::getFreezeTime), (App)Codec.FLOAT.fieldOf("experience").forGetter(FreezerRecipe::getExperience)).apply((Applicative)inst, FreezerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FreezerRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, FreezerRecipe::getId, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FreezerRecipe::input, (StreamCodec)ItemStack.STREAM_CODEC, FreezerRecipe::output, (StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, Integer>(){

            public void encode(RegistryFriendlyByteBuf buf, Integer value) {
                buf.writeInt(value.intValue());
            }

            public Integer decode(RegistryFriendlyByteBuf buf) {
                return buf.readInt();
            }
        }, FreezerRecipe::getFreezeTime, (StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, Float>(){

            public void encode(RegistryFriendlyByteBuf buf, Float value) {
                buf.writeFloat(value.floatValue());
            }

            public Float decode(RegistryFriendlyByteBuf buf) {
                return Float.valueOf(buf.readFloat());
            }
        }, FreezerRecipe::getExperience, FreezerRecipe::new);

        public MapCodec<FreezerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FreezerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

