/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.custom.CabinetBlock;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.block.custom.KitchenDrawerBlock;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class KitchenCounterBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public KitchenCounterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TYPE, (Comparable)((Object)Type.DEFAULT))).setValue((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return null;
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape TOP = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape[] DEFAULT_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] LEFT_INVERTED_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] RIGHT_INVERTED_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)13.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] LEFT_CORNER_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)13.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] RIGHT_CORNER_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)13.0, (double)16.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            Type type = (Type)((Object)state.getValue(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TOP);
            switch (type.ordinal()) {
                case 0: {
                    shapes.add(DEFAULT_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    break;
                }
                case 1: {
                    shapes.add(DEFAULT_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    shapes.add(LEFT_CORNER_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    break;
                }
                case 2: {
                    shapes.add(DEFAULT_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    shapes.add(RIGHT_CORNER_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    break;
                }
                case 3: {
                    shapes.add(LEFT_INVERTED_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    break;
                }
                case 4: {
                    shapes.add(RIGHT_INVERTED_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    protected BlockState updateShape(BlockState state, LevelReader reader, ScheduledTickAccess access, BlockPos pos, Direction direction, BlockPos pos1, BlockState state1, RandomSource rand) {
        return this.getKitchenCounterState(state, (LevelReader)((LevelAccessor)reader), pos);
    }

    private BlockState getKitchenCounterState(BlockState state, LevelReader level, BlockPos pos) {
        BlockState backState;
        Direction direction = (Direction)state.getValue((Property)DIRECTION);
        BlockState frontState = level.getBlockState(pos.relative(direction.getOpposite()));
        if (this.isKitchenBlock(frontState)) {
            if (frontState.getValue((Property)DIRECTION) == direction.getClockWise()) {
                return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.RIGHT_CORNER));
            }
            if (frontState.getValue((Property)DIRECTION) == direction.getCounterClockWise()) {
                return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.LEFT_CORNER));
            }
        }
        if ((backState = level.getBlockState(pos.relative(direction))).getBlock() instanceof KitchenCounterBlock) {
            BlockState rightState;
            BlockState leftState;
            if (!(backState.getValue((Property)DIRECTION) != direction.getClockWise() || (leftState = level.getBlockState(pos.relative(direction.getCounterClockWise()))).getBlock() instanceof KitchenCounterBlock && leftState.getValue((Property)DIRECTION) != direction.getOpposite())) {
                return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.LEFT_CORNER_INVERTED));
            }
            if (!(backState.getValue((Property)DIRECTION) != direction.getCounterClockWise() || (rightState = level.getBlockState(pos.relative(direction.getClockWise()))).getBlock() instanceof KitchenCounterBlock && rightState.getValue((Property)DIRECTION) != direction.getOpposite())) {
                return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.RIGHT_CORNER_INVERTED));
            }
        }
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.DEFAULT));
    }

    protected boolean isKitchenBlock(BlockState state) {
        return state.getBlock() instanceof KitchenCounterBlock || state.getBlock() instanceof KitchenDrawerBlock || state.getBlock() instanceof CabinetBlock;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        DEFAULT("default"),
        LEFT_CORNER("left_corner"),
        RIGHT_CORNER("right_corner"),
        LEFT_CORNER_INVERTED("left_corner_inverted"),
        RIGHT_CORNER_INVERTED("right_corner_inverted");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return this.id;
        }
    }
}

