/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.entity.custom.FreezerBlockEntity;
import net.tier1234.better_deco.block.entity.custom.FridgeBlockEntity;
import net.tier1234.better_deco.util.VoxelShapeHelper;
import org.jetbrains.annotations.Nullable;

public class NewFridgeBlock
extends BaseEntityBlock {
    public static final MapCodec<NewFridgeBlock> CODEC = NewFridgeBlock.simpleCodec(NewFridgeBlock::new);
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<FridgeModelType> MODEL_TYPE = EnumProperty.create((String)"model", FridgeModelType.class);
    private static final VoxelShape FRIDGE = Stream.of(Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)23.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)23.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)23.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)16.0)).reduce((v1, v2) -> Shapes.or((VoxelShape)v1, (VoxelShape)v2)).get();
    private static final VoxelShape FREEZER = Stream.of(Block.box((double)0.0, (double)7.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.or((VoxelShape)v1, (VoxelShape)v2)).get();
    private static final VoxelShape[] SHAPES = new VoxelShape[8];

    public NewFridgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(DIRECTION, (Comparable)Direction.NORTH)).setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.FRIDGE)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DIRECTION, MODEL_TYPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        if (level.getBlockState(blockPos.above()).canBeReplaced(context)) {
            return (BlockState)this.defaultBlockState().setValue(DIRECTION, (Comparable)context.getHorizontalDirection().getOpposite());
        }
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (state.getValue(MODEL_TYPE) == FridgeModelType.FRIDGE) {
            if (blockEntity instanceof FridgeBlockEntity) {
                FridgeBlockEntity fridgeBlockEntity = (FridgeBlockEntity)blockEntity;
                player.openMenu((MenuProvider)fridgeBlockEntity);
                return InteractionResult.CONSUME;
            }
        } else if (state.getValue(MODEL_TYPE) == FridgeModelType.FREEZER && blockEntity instanceof FreezerBlockEntity) {
            FreezerBlockEntity freezerBlockEntity = (FreezerBlockEntity)blockEntity;
            ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)freezerBlockEntity, (Component)Component.translatable((String)"gui.better_deco.freezer")), pos);
        }
        return InteractionResult.CONSUME;
    }

    private static Direction getNeighbourDirection(FridgeModelType modelType) {
        return modelType == FridgeModelType.FRIDGE ? Direction.UP : Direction.DOWN;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        FridgeModelType modelType;
        BlockPos otherPos;
        BlockState otherState;
        if (!level.isClientSide() && (otherState = level.getBlockState(otherPos = pos.relative(NewFridgeBlock.getNeighbourDirection(modelType = (FridgeModelType)((Object)state.getValue(MODEL_TYPE)))))).getBlock() == this && otherState.getValue(MODEL_TYPE) != modelType) {
            BlockPos bottomPos = modelType == FridgeModelType.FRIDGE ? pos : otherPos;
            BlockPos topPos = modelType == FridgeModelType.FREEZER ? pos : otherPos;
            level.setBlock(bottomPos, Blocks.AIR.defaultBlockState(), 3);
            level.levelEvent((Entity)player, 2001, bottomPos, Block.getId((BlockState)state));
            level.setBlock(topPos, Blocks.AIR.defaultBlockState(), 3);
            level.levelEvent((Entity)player, 2001, topPos, Block.getId((BlockState)otherState));
            if (!player.isCreative()) {
                NewFridgeBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
                NewFridgeBlock.dropResources((BlockState)otherState, (Level)level, (BlockPos)otherPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos above;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide() && level.getBlockState(above = pos.above()).canBeReplaced()) {
            level.setBlock(above, (BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.FREEZER)), 3);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.getValue(MODEL_TYPE) == FridgeModelType.FREEZER) {
            return new FreezerBlockEntity(pos, state);
        }
        return new FridgeBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue(DIRECTION);
        int d2d = direction.get2DDataValue();
        if (state.getValue(MODEL_TYPE) == FridgeModelType.FRIDGE) {
            return SHAPES[4 + d2d];
        }
        return SHAPES[d2d];
    }

    static {
        NewFridgeBlock.SHAPES[0] = VoxelShapeHelper.rotateShape(FREEZER, Direction.SOUTH);
        NewFridgeBlock.SHAPES[1] = VoxelShapeHelper.rotateShape(FREEZER, Direction.WEST);
        NewFridgeBlock.SHAPES[2] = VoxelShapeHelper.rotateShape(FREEZER, Direction.NORTH);
        NewFridgeBlock.SHAPES[3] = VoxelShapeHelper.rotateShape(FREEZER, Direction.EAST);
        NewFridgeBlock.SHAPES[4] = VoxelShapeHelper.rotateShape(FRIDGE, Direction.SOUTH);
        NewFridgeBlock.SHAPES[5] = VoxelShapeHelper.rotateShape(FRIDGE, Direction.WEST);
        NewFridgeBlock.SHAPES[6] = VoxelShapeHelper.rotateShape(FRIDGE, Direction.NORTH);
        NewFridgeBlock.SHAPES[7] = VoxelShapeHelper.rotateShape(FRIDGE, Direction.EAST);
    }

    public static enum FridgeModelType implements StringRepresentable
    {
        FRIDGE,
        FREEZER;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.getSerializedName();
        }
    }
}

