/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.custom;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tier1234.better_deco.block.entity.ModBlockEntities;
import net.tier1234.better_deco.recipe.FreezerRecipe;
import net.tier1234.better_deco.recipe.FreezerRecipeInput;
import net.tier1234.better_deco.recipe.ModRecipes;
import net.tier1234.better_deco.screen.custom.FreezerMenu;

public class FreezerBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            FreezerBlockEntity.this.setChanged();
            if (!FreezerBlockEntity.this.level.isClientSide()) {
                FreezerBlockEntity.this.level.sendBlockUpdated(FreezerBlockEntity.this.getBlockPos(), FreezerBlockEntity.this.getBlockState(), FreezerBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_OUTPUT = 2;
    private int fuelTime;
    private int fuelTimeTotal;
    private int freezeTime;
    private int freezeTimeTotal;
    private final Map<ResourceLocation, Integer> usedRecipeCount = Maps.newHashMap();
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> FreezerBlockEntity.this.fuelTime;
                case 1 -> FreezerBlockEntity.this.fuelTimeTotal;
                case 2 -> FreezerBlockEntity.this.freezeTime;
                case 3 -> FreezerBlockEntity.this.freezeTimeTotal;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    FreezerBlockEntity.this.fuelTime = value;
                    break;
                }
                case 1: {
                    FreezerBlockEntity.this.fuelTimeTotal = value;
                    break;
                }
                case 2: {
                    FreezerBlockEntity.this.freezeTime = value;
                    break;
                }
                case 3: {
                    FreezerBlockEntity.this.freezeTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public FreezerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FREEZER.get(), pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.better_deco.freezer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new FreezerMenu(id, inv, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    private Optional<RecipeHolder<FreezerRecipe>> getRecipeFor(ItemStack input) {
        return ((ServerLevel)this.level).recipeAccess().getRecipeFor((RecipeType)ModRecipes.FREEZER_TYPE.get(), (RecipeInput)new FreezerRecipeInput(input), this.level);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FreezerBlockEntity be) {
        boolean dirty = false;
        if (be.isFreezing()) {
            --be.fuelTime;
        }
        ItemStack fuelStack = be.itemHandler.getStackInSlot(1);
        ItemStack inputStack = be.itemHandler.getStackInSlot(0);
        Optional<RecipeHolder<FreezerRecipe>> recipe = be.getRecipeFor(inputStack);
        if (!be.isFreezing() && recipe.isPresent() && be.canFreeze(recipe.get()) && !fuelStack.isEmpty()) {
            be.fuelTimeTotal = be.fuelTime = be.getFuelTime(fuelStack);
            if (be.isFreezing()) {
                fuelStack.shrink(1);
                dirty = true;
            }
        }
        if (be.isFreezing() && recipe.isPresent() && be.canFreeze(recipe.get())) {
            ++be.freezeTime;
            be.freezeTimeTotal = be.getFreezeTime(recipe.get());
            if (be.freezeTime >= be.freezeTimeTotal) {
                be.freezeTime = 0;
                be.freeze(recipe.get());
                dirty = true;
            }
        } else {
            be.freezeTime = 0;
        }
        if (dirty) {
            FreezerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean isFreezing() {
        return this.fuelTime > 0;
    }

    private int getFuelTime(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.is(Items.ICE)) {
            return 2000;
        }
        if (stack.is(Items.PACKED_ICE)) {
            return 18000;
        }
        if (stack.is(Items.BLUE_ICE)) {
            return 162000;
        }
        return 0;
    }

    private int getFreezeTime(RecipeHolder<FreezerRecipe> recipe) {
        return ((FreezerRecipe)recipe.value()).getFreezeTime();
    }

    private boolean canFreeze(RecipeHolder<FreezerRecipe> recipe) {
        ItemStack output = ((FreezerRecipe)recipe.value()).output();
        if (output.isEmpty()) {
            return false;
        }
        ItemStack resultStack = this.itemHandler.getStackInSlot(2);
        if (resultStack.isEmpty()) {
            return true;
        }
        return resultStack.getCount() + output.getCount() <= resultStack.getMaxStackSize();
    }

    private void freeze(RecipeHolder<FreezerRecipe> recipe) {
        if (!this.canFreeze(recipe)) {
            return;
        }
        this.itemHandler.extractItem(0, 1, false);
        ItemStack resultStack = this.itemHandler.getStackInSlot(2);
        ItemStack output = ((FreezerRecipe)recipe.value()).output();
        if (resultStack.isEmpty()) {
            this.itemHandler.setStackInSlot(2, output.copy());
        } else {
            resultStack.grow(output.getCount());
        }
        if (!this.level.isClientSide()) {
            this.usedRecipeCount.merge(recipe.id().registry(), 1, Integer::sum);
        }
    }

    protected void saveAdditional(ValueOutput output) {
        this.itemHandler.serialize(output);
        output.putInt("FuelTime", this.fuelTime);
        output.putInt("FuelTimeTotal", this.fuelTimeTotal);
        output.putInt("FreezeTime", this.freezeTime);
        output.putInt("FreezeTimeTotal", this.freezeTimeTotal);
        output.putInt("RecipesUsedSize", this.usedRecipeCount.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> e : this.usedRecipeCount.entrySet()) {
            output.putString("RecipeLocation" + i, e.getKey().toString());
            output.putInt("RecipeAmount" + i, e.getValue().intValue());
            ++i;
        }
        super.saveAdditional(output);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.itemHandler.deserialize(input);
        this.fuelTime = input.getIntOr("FuelTime", 0);
        this.fuelTimeTotal = input.getIntOr("FuelTimeTotal", 0);
        this.freezeTime = input.getIntOr("FreezeTime", 0);
        this.freezeTimeTotal = input.getIntOr("FreezeTimeTotal", 0);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

