/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.renderer.core.core_render;

import net.minecraft.util.Mth;

public class FastColor {
    private FastColor() {
    }

    public static int toChannel8Bit(float value) {
        return Mth.floor((float)(value * 255.0f));
    }

    public static final class ARGB32 {
        private ARGB32() {
        }

        public static int alpha(int color) {
            return color >>> 24 & 0xFF;
        }

        public static int red(int color) {
            return color >>> 16 & 0xFF;
        }

        public static int green(int color) {
            return color >>> 8 & 0xFF;
        }

        public static int blue(int color) {
            return color & 0xFF;
        }

        public static int fromRGBA(int a, int r, int g, int b) {
            return a << 24 | r << 16 | g << 8 | b;
        }

        public static int fromRGB(int r, int g, int b) {
            return ARGB32.fromRGBA(255, r, g, b);
        }

        public static int multiply(int c1, int c2) {
            int a = ARGB32.alpha(c1) * ARGB32.alpha(c2) / 255;
            int r = ARGB32.red(c1) * ARGB32.red(c2) / 255;
            int g = ARGB32.green(c1) * ARGB32.green(c2) / 255;
            int b = ARGB32.blue(c1) * ARGB32.blue(c2) / 255;
            return ARGB32.fromRGBA(a, r, g, b);
        }

        public static int lerp(float delta, int c1, int c2) {
            int a = Mth.lerpInt((float)delta, (int)ARGB32.alpha(c1), (int)ARGB32.alpha(c2));
            int r = Mth.lerpInt((float)delta, (int)ARGB32.red(c1), (int)ARGB32.red(c2));
            int g = Mth.lerpInt((float)delta, (int)ARGB32.green(c1), (int)ARGB32.green(c2));
            int b = Mth.lerpInt((float)delta, (int)ARGB32.blue(c1), (int)ARGB32.blue(c2));
            return ARGB32.fromRGBA(a, r, g, b);
        }

        public static int withFullAlpha(int color) {
            return color | 0xFF000000;
        }

        public static int withAlpha(int alpha, int rgb) {
            return alpha << 24 | rgb & 0xFFFFFF;
        }

        public static int fromFloats(float a, float r, float g, float b) {
            return ARGB32.fromRGBA(FastColor.toChannel8Bit(a), FastColor.toChannel8Bit(r), FastColor.toChannel8Bit(g), FastColor.toChannel8Bit(b));
        }

        public static int average(int c1, int c2) {
            int a = (ARGB32.alpha(c1) + ARGB32.alpha(c2)) / 2;
            int r = (ARGB32.red(c1) + ARGB32.red(c2)) / 2;
            int g = (ARGB32.green(c1) + ARGB32.green(c2)) / 2;
            int b = (ARGB32.blue(c1) + ARGB32.blue(c2)) / 2;
            return ARGB32.fromRGBA(a, r, g, b);
        }
    }

    public static final class ABGR32 {
        private ABGR32() {
        }

        public static int getA(int color) {
            return color >>> 24;
        }

        public static int getR(int color) {
            return color & 0xFF;
        }

        public static int getG(int color) {
            return color >>> 8 & 0xFF;
        }

        public static int getB(int color) {
            return color >>> 16 & 0xFF;
        }

        public static int makeTransparent(int color) {
            return color & 0xFFFFFF;
        }

        public static int makeOpaque(int color) {
            return color | 0xFF000000;
        }

        public static int fromComponents(int a, int b, int g, int r) {
            return a << 24 | b << 16 | g << 8 | r;
        }

        public static int applyAlpha(int alpha, int rgb) {
            return alpha << 24 | rgb & 0xFFFFFF;
        }

        public static int convertFromArgb(int color) {
            int a = color >>> 24 & 0xFF;
            int r = color >>> 16 & 0xFF;
            int g = color >>> 8 & 0xFF;
            int b = color & 0xFF;
            return a << 24 | b << 16 | g << 8 | r;
        }
    }
}

