/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.renderer.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.tier1234.better_deco.block.custom.DigitalClockBlock;
import net.tier1234.better_deco.block.entity.custom.DigitalClockBlockEntity;
import net.tier1234.better_deco.block.entity.renderer.core.render_state.DigitalClockRendererState;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class DigitalClockBlockEntityRenderer
implements BlockEntityRenderer<DigitalClockBlockEntity, DigitalClockRendererState> {
    private final Font font;

    public DigitalClockBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.font();
    }

    public DigitalClockRendererState createRenderState() {
        return new DigitalClockRendererState();
    }

    public void extractRenderState(DigitalClockBlockEntity blockEntity, DigitalClockRendererState state, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        BlockState blockState = blockEntity.getBlockState();
        if (!(blockState.getBlock() instanceof DigitalClockBlock)) {
            return;
        }
        state.facing = (Direction)blockState.getValue((Property)DigitalClockBlock.DIRECTION);
        state.timeText = DigitalClockBlockEntity.getFormattedTime(blockEntity.getLevel().getDayTime());
        state.color = DigitalClockBlockEntity.getFromColor(blockEntity.getTextColor());
        state.lightPosition = blockEntity.getBlockPos();
        state.level = blockEntity.getLevel();
    }

    public void submit(DigitalClockRendererState state, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState camera) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        Direction facing = state.facing != null ? state.facing : Direction.NORTH;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f * (float)facing.get2DDataValue() + 180.0f));
        poseStack.translate(0.0675, 0.005, -0.032);
        poseStack.translate(-0.2625, -0.3125, 0.096875);
        float baseScale = 0.015625f;
        poseStack.scale(baseScale, -baseScale, baseScale);
        int light = this.getLightLevel(state.level, state.lightPosition);
        this.font.drawInBatch(state.timeText, 0.0f, 0.0f, state.color, false, poseStack.last().pose(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, light);
        poseStack.popPose();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return LightTexture.pack((int)15, (int)15);
        }
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

