/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.renderer.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.tier1234.better_deco.block.entity.custom.ShelfBlockEntity;
import net.tier1234.better_deco.block.entity.renderer.core.render_state.ShelfRendererState;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class ShelfBlockEntityRenderer
implements BlockEntityRenderer<ShelfBlockEntity, ShelfRendererState> {
    private final ItemModelResolver itemModelResolver;
    private static final float U1 = 0.0625f;

    public ShelfBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public ShelfRendererState createRenderState() {
        return new ShelfRendererState();
    }

    public void extractRenderState(ShelfBlockEntity blockEntity, ShelfRendererState state, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        state.lightPosition = blockEntity.getBlockPos();
        state.blockEntityLevel = blockEntity.getLevel();
        for (int i = 0; i < state.itemRenderStates.size(); ++i) {
            ItemStack stack = blockEntity.handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            this.itemModelResolver.updateForTopItem(state.itemRenderStates.get(i), stack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        }
        state.facing = (Direction)blockEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
    }

    public void submit(ShelfRendererState state, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState camera) {
        poseStack.pushPose();
        Direction facing = state.facing != null ? state.facing : Direction.NORTH;
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-facing.toYRot()));
        int light = this.getLightLevel(state.blockEntityLevel, state.lightPosition);
        float scale = 0.3f;
        float xOffset = 5.2f;
        float yOffset = 3.5f;
        float yOffset2 = 4.5f;
        float zOffset = 0.15f;
        for (int i = 0; i < state.itemRenderStates.size(); ++i) {
            ItemStackRenderState itemState = state.itemRenderStates.get(i);
            poseStack.pushPose();
            int row = i / 3;
            int col = i % 3;
            float baseX = -0.35f + (float)col * 0.35f;
            float baseY = 0.25f + (float)row * 0.5f;
            float baseZ = -0.3f;
            poseStack.translate(baseX, baseY, baseZ);
            poseStack.scale(0.35f, 0.35f, 0.35f);
            itemState.submit(poseStack, submitNodeCollector, light, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return LightTexture.pack((int)15, (int)15);
        }
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

