/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tier1234.better_deco.recipe.FreezerRecipeInput;
import net.tier1234.better_deco.recipe.ModRecipes;

public record FreezerRecipe(Ingredient inputItem, ItemStack output, int freezeTime) implements Recipe<FreezerRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.inputItem);
        return list;
    }

    public boolean matches(FreezerRecipeInput recipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.inputItem.test(recipeInput.getItem(0));
    }

    public ItemStack assemble(FreezerRecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<? extends Recipe<FreezerRecipeInput>> getSerializer() {
        return (RecipeSerializer)ModRecipes.FREEZER_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<FreezerRecipeInput>> getType() {
        return (RecipeType)ModRecipes.FREEZER_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create((Ingredient)this.inputItem);
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public int getFreezeTime() {
        return this.freezeTime;
    }

    public static class Serializer
    implements RecipeSerializer<FreezerRecipe> {
        public static final MapCodec<FreezerRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(FreezerRecipe::inputItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(FreezerRecipe::output), (App)Codec.INT.optionalFieldOf("freezeTime", (Object)200).forGetter(FreezerRecipe::getFreezeTime)).apply((Applicative)inst, FreezerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FreezerRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FreezerRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, FreezerRecipe::output, (StreamCodec)ByteBufCodecs.VAR_INT, FreezerRecipe::getFreezeTime, FreezerRecipe::new);

        public MapCodec<FreezerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FreezerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

