/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.util;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape combineAll(Collection<VoxelShape> shapes) {
        VoxelShape result = Shapes.empty();
        for (VoxelShape shape : shapes) {
            result = Shapes.joinUnoptimized((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.OR);
        }
        return result.optimize();
    }

    public static VoxelShape setMaxHeight(VoxelShape source, double height) {
        AtomicReference<VoxelShape> result = new AtomicReference<VoxelShape>(Shapes.empty());
        source.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape shape = Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)height, (double)maxZ);
            result.set(Shapes.joinUnoptimized((VoxelShape)((VoxelShape)result.get()), (VoxelShape)shape, (BooleanOp)BooleanOp.OR));
        });
        return result.get().optimize();
    }

    public static VoxelShape limitHorizontal(VoxelShape source) {
        AtomicReference<VoxelShape> result = new AtomicReference<VoxelShape>(Shapes.empty());
        source.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape shape = Shapes.box((double)VoxelShapeHelper.limit(minX), (double)minY, (double)VoxelShapeHelper.limit(minZ), (double)VoxelShapeHelper.limit(maxX), (double)maxY, (double)VoxelShapeHelper.limit(maxZ));
            result.set(Shapes.joinUnoptimized((VoxelShape)((VoxelShape)result.get()), (VoxelShape)shape, (BooleanOp)BooleanOp.OR));
        });
        return result.get().optimize();
    }

    public static VoxelShape[] getRotatedShapes(VoxelShape source) {
        VoxelShape shapeNorth = VoxelShapeHelper.rotate(source, Direction.NORTH);
        VoxelShape shapeEast = VoxelShapeHelper.rotate(source, Direction.EAST);
        VoxelShape shapeSouth = VoxelShapeHelper.rotate(source, Direction.SOUTH);
        VoxelShape shapeWest = VoxelShapeHelper.rotate(source, Direction.WEST);
        return new VoxelShape[]{shapeSouth, shapeWest, shapeNorth, shapeEast};
    }

    public static VoxelShape rotate(VoxelShape source, Direction direction) {
        double[] adjustedValues = VoxelShapeHelper.adjustValues(direction, source.min(Direction.Axis.X), source.min(Direction.Axis.Z), source.max(Direction.Axis.X), source.max(Direction.Axis.Z));
        return Shapes.box((double)adjustedValues[0], (double)source.min(Direction.Axis.Y), (double)adjustedValues[1], (double)adjustedValues[2], (double)source.max(Direction.Axis.Y), (double)adjustedValues[3]);
    }

    private static double[] adjustValues(Direction direction, double var1, double var2, double var3, double var4) {
        switch (direction) {
            case WEST: {
                double var_temp_1 = var1;
                var1 = 1.0 - var3;
                double var_temp_2 = var2;
                var2 = 1.0 - var4;
                var3 = 1.0 - var_temp_1;
                var4 = 1.0 - var_temp_2;
                break;
            }
            case NORTH: {
                double var_temp_3 = var1;
                var1 = var2;
                var2 = 1.0 - var3;
                var3 = var4;
                var4 = 1.0 - var_temp_3;
                break;
            }
            case SOUTH: {
                double var_temp_4 = var1;
                var1 = 1.0 - var4;
                double var_temp_5 = var2;
                var2 = var_temp_4;
                double var_temp_6 = var3;
                var3 = 1.0 - var_temp_5;
                var4 = var_temp_6;
                break;
            }
        }
        return new double[]{var1, var2, var3, var4};
    }

    private static double limit(double value) {
        return Math.max(0.0, Math.min(1.0, value));
    }

    public static VoxelShape rotateHorizontally(VoxelShape shape, Direction direction) {
        Preconditions.checkArgument((boolean)direction.getAxis().isHorizontal());
        return shape.toAabbs().stream().map(box -> VoxelShapeHelper.createRotatedShape(box, direction)).reduce(Shapes.empty(), VoxelShapeHelper::join);
    }

    public static VoxelShape combine(List<VoxelShape> shapes) {
        return shapes.stream().reduce(Shapes.empty(), VoxelShapeHelper::join).optimize();
    }

    private static VoxelShape join(VoxelShape a, VoxelShape b) {
        return Shapes.joinUnoptimized((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR);
    }

    private static VoxelShape createRotatedShape(AABB box, Direction direction) {
        return switch (direction) {
            case Direction.WEST -> Shapes.box((double)(1.0 - box.maxX), (double)box.minY, (double)(1.0 - box.maxZ), (double)(1.0 - box.minX), (double)box.maxY, (double)(1.0 - box.minZ));
            case Direction.NORTH -> Shapes.box((double)box.minZ, (double)box.minY, (double)(1.0 - box.maxX), (double)box.maxZ, (double)box.maxY, (double)(1.0 - box.minX));
            case Direction.SOUTH -> Shapes.box((double)(1.0 - box.maxZ), (double)box.minY, (double)box.minX, (double)(1.0 - box.minZ), (double)box.maxY, (double)box.maxX);
            default -> Shapes.box((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ);
        };
    }

    public static VoxelShape rotateShape(VoxelShape source, Direction direction) {
        AtomicReference<VoxelShape> newShape = new AtomicReference<VoxelShape>(Shapes.empty());
        source.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vec3 min = new Vec3(minX - 0.5, minY - 0.5, minZ - 0.5);
            Vec3 max = new Vec3(maxX - 0.5, maxY - 0.5, maxZ - 0.5);
            Vec3 v1 = VoxelShapeHelper.rotateVec3(min, direction);
            Vec3 v2 = VoxelShapeHelper.rotateVec3(max, direction);
            VoxelShape s = Shapes.create((double)(0.5 + Math.min(v1.x, v2.x)), (double)(0.5 + Math.min(v1.y, v2.y)), (double)(0.5 + Math.min(v1.z, v2.z)), (double)(0.5 + Math.max(v1.x, v2.x)), (double)(0.5 + Math.max(v1.y, v2.y)), (double)(0.5 + Math.max(v1.z, v2.z)));
            newShape.set(Shapes.or((VoxelShape)((VoxelShape)newShape.get()), (VoxelShape)s));
        });
        return newShape.get();
    }

    public static Vec3 rotateVec3(Vec3 vec, Direction dir) {
        double cos = 1.0;
        double sin = 0.0;
        switch (dir) {
            case SOUTH: {
                cos = -1.0;
                sin = 0.0;
                break;
            }
            case WEST: {
                cos = 0.0;
                sin = 1.0;
                break;
            }
            case EAST: {
                cos = 0.0;
                sin = -1.0;
            }
        }
        double d0 = vec.x * cos + vec.z * sin;
        double d1 = vec.y;
        double d2 = vec.z * cos - vec.x * sin;
        return new Vec3(d0, d1, d2);
    }
}

