/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.tier1234.better_deco.block.ModBlocks;
import net.tier1234.better_deco.block.entity.ModBlockEntities;
import net.tier1234.better_deco.block.entity.renderer.DigitalClockBlockEntityRenderer;
import net.tier1234.better_deco.block.entity.renderer.KitchenSinkBlockEntityRenderer;
import net.tier1234.better_deco.block.entity.renderer.PedestalBlockEntityRenderer;
import net.tier1234.better_deco.block.entity.renderer.ShelfBlockEntityRenderer;
import net.tier1234.better_deco.block.entity.renderer.TecqueBlockEntityRenderer;
import net.tier1234.better_deco.creative_tabs.ModCreativeTabs;
import net.tier1234.better_deco.entity.ModEntities;
import net.tier1234.better_deco.entity.client.ChairRenderer;
import net.tier1234.better_deco.item.ModItems;
import net.tier1234.better_deco.recipe.ModRecipes;
import net.tier1234.better_deco.screen.ModMenuTypes;
import net.tier1234.better_deco.screen.custom.CrateScreen;
import net.tier1234.better_deco.screen.custom.MicrowaveScreen;
import net.tier1234.better_deco.screen.custom.OvenScreen;
import net.tier1234.better_deco.screen.custom.PedestalScreen;
import net.tier1234.better_deco.screen.custom.ShelfScreen;
import net.tier1234.better_deco.screen.custom.SinkScreen;
import net.tier1234.better_deco.screen.custom.TecqueScreen;
import org.slf4j.Logger;

@Mod(value="better_deco")
public class BetterDeco {
    public static final String MOD_ID = "better_deco";
    private static final Logger LOGGER = LogUtils.getLogger();

    public BetterDeco(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModEntities.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        modEventBus.addListener(this::addCreative);
    }

    public static ResourceLocation id(String path, Object ... args) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)String.format(path, args));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="better_deco", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.CHAIR_ENTITY.get(), ChairRenderer::new);
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ModBlockEntities.PEDESTAL_BE.get(), PedestalBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.GLASS_TECQUE.get(), TecqueBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.SHELF_BE.get(), ShelfBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.DIGITAL_CLOCK.get(), DigitalClockBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.KITCHEN_SINK.get(), KitchenSinkBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.TECQUE_MENU.get(), TecqueScreen::new);
            event.register((MenuType)ModMenuTypes.PEDESTAL_MENU.get(), PedestalScreen::new);
            event.register((MenuType)ModMenuTypes.CRATE_MENU.get(), CrateScreen::new);
            event.register((MenuType)ModMenuTypes.SHELF_MENU.get(), ShelfScreen::new);
            event.register((MenuType)ModMenuTypes.OVEN_MENU.get(), OvenScreen::new);
            event.register((MenuType)ModMenuTypes.MICROWAVE_MENU.get(), MicrowaveScreen::new);
            event.register((MenuType)ModMenuTypes.SINK_MENU.get(), SinkScreen::new);
        }
    }
}

