/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.block.entity.KitchenSinkBlockEntity;
import net.tier1234.better_deco.util.VoxelShapeHelper;
import org.jetbrains.annotations.Nullable;

public class KitchenSinkBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());

    public KitchenSinkBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)15.0), Direction.SOUTH))[direction.get2DDataValue()]);
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH))[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    private boolean isWaterSource(Level level, BlockPos pos) {
        return level.getFluidState(pos).isSourceOfType((Fluid)Fluids.WATER);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KitchenSinkBlockEntity(pos, state);
    }
}

