/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class VerticalSlabBlock
extends SlabBlock {
    private static final MapCodec<VerticalSlabBlock> CODEC = VerticalSlabBlock.simpleCodec(VerticalSlabBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS});
    }

    public static Direction toDirection(BlockState state) {
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Y -> throw new IllegalStateException("Y axis is not supported for vertical slabs");
            case Direction.Axis.X -> {
                if (state.getValue((Property)TYPE) == SlabType.BOTTOM) {
                    yield Direction.EAST;
                }
                yield Direction.WEST;
            }
            case Direction.Axis.Z -> state.getValue((Property)TYPE) == SlabType.BOTTOM ? Direction.SOUTH : Direction.NORTH;
        };
    }

    public static BlockState applyBlockState(BlockState state, Direction facing) {
        if ((state = (BlockState)state.setValue(AXIS, (Comparable)facing.getAxis())).getValue((Property)TYPE) != SlabType.DOUBLE) {
            state = (BlockState)state.setValue((Property)TYPE, (Comparable)(facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? SlabType.BOTTOM : SlabType.TOP));
        }
        return state;
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(VerticalSlabBlock.toDirection(state)));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return VerticalSlabBlock.applyBlockState(state, rotation.rotate(VerticalSlabBlock.toDirection(state)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        SlabType slabType = (SlabType)state.getValue((Property)TYPE);
        if (slabType == SlabType.DOUBLE) {
            return Shapes.block();
        }
        return switch (VerticalSlabBlock.toDirection(state)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> throw new IllegalStateException("Unreachable statement");
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        if (state.is((Block)this)) {
            return (BlockState)((BlockState)state.setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidState = context.getLevel().getFluidState(pos);
        BlockState toPlace = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return VerticalSlabBlock.applyBlockState(toPlace, context.getHorizontalDirection());
    }

    public MapCodec<? extends SlabBlock> codec() {
        return CODEC;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        ItemStack stack = useContext.getItemInHand();
        SlabType type = (SlabType)state.getValue((Property)TYPE);
        if (type == SlabType.DOUBLE || !stack.is(this.asItem())) {
            return false;
        }
        if (useContext.replacingClickedOnBlock()) {
            Direction dir = VerticalSlabBlock.toDirection(state);
            return dir == useContext.getClickedFace().getOpposite();
        }
        return false;
    }
}

