/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.tier1234.better_deco.block.custom.BedsideCabinetBlock;
import net.tier1234.better_deco.block.entity.BasicLootBlockEntity;
import net.tier1234.better_deco.block.entity.ModBlockEntities;

public class BedsideCabinetBlockEntity
extends BasicLootBlockEntity {
    public BedsideCabinetBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BEDSIDE_CABINET.get(), pos, state);
    }

    @Override
    public int getContainerSize() {
        return 9;
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"Bedside");
    }

    @Override
    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return new ChestMenu(MenuType.GENERIC_9x1, windowId, playerInventory, (Container)this, 1);
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        this.playDoorSound(state, SoundEvents.UI_STONECUTTER_TAKE_RESULT);
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        this.playDoorSound(state, SoundEvents.UI_STONECUTTER_TAKE_RESULT);
        this.setDoorState(state, false);
    }

    private void playDoorSound(BlockState blockState, SoundEvent soundEvent) {
        Vec3i directionVec = ((Direction)blockState.getValue((Property)BedsideCabinetBlock.DIRECTION)).getUnitVec3i();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)directionVec.getX() / 2.0;
        double y = (double)this.worldPosition.getY() + 0.5 + (double)directionVec.getY() / 2.0;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)directionVec.getZ() / 2.0;
        Level level = this.getLevel();
        if (level != null) {
            level.playSound(null, x, y, z, soundEvent, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    private void setDoorState(BlockState blockState, boolean open) {
        Level level = this.getLevel();
        if (level != null) {
            level.setBlock(this.getBlockPos(), (BlockState)blockState.setValue((Property)BedsideCabinetBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }
}

