/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tier1234.better_deco.block.entity.ModBlockEntities;

public class CabinetBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(18);
    private NonNullList<ItemStack> items = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);

    public CabinetBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CUSTOM_CABINET_BE.get(), pos, state);
    }

    protected Component getDefaultName() {
        return Component.literal((String)"Kitchen Cabinet");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return ChestMenu.twoRows((int)id, (Inventory)playerInventory);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, (CompoundTag)tag.getCompound("inventory").get());
    }
}

