/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tier1234.better_deco.block.entity.ModBlockEntities;
import net.tier1234.better_deco.recipe.ModRecipes;
import net.tier1234.better_deco.recipe.OvenRecipe;
import net.tier1234.better_deco.recipe.OvenRecipeInput;
import net.tier1234.better_deco.screen.custom.OvenMenu;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            OvenBlockEntity.this.setChanged();
            if (!OvenBlockEntity.this.level.isClientSide()) {
                OvenBlockEntity.this.level.sendBlockUpdated(OvenBlockEntity.this.getBlockPos(), OvenBlockEntity.this.getBlockState(), OvenBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2};
    private static final int[] OUTPUT_SLOTS = new int[]{3, 4, 5};
    protected final ContainerData data;
    private final int[] progress = new int[3];
    private final int maxProgress = 72;

    public OvenBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.OVEN.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int i) {
                return i < 3 ? OvenBlockEntity.this.progress[i] : 0;
            }

            public void set(int i, int value) {
                if (i < 3) {
                    OvenBlockEntity.this.progress[i] = value;
                }
            }

            public int getCount() {
                return 3;
            }
        };
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        this.drops();
        super.preRemoveSideEffects(pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.better_deco.oven");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new OvenMenu(id, inv, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean changed = false;
        for (int i = 0; i < 3; ++i) {
            if (this.hasRecipe(INPUT_SLOTS[i], OUTPUT_SLOTS[i])) {
                int n = i;
                this.progress[n] = this.progress[n] + 1;
                changed = true;
                if (this.progress[i] < 72) continue;
                this.craftItem(INPUT_SLOTS[i], OUTPUT_SLOTS[i]);
                this.progress[i] = 0;
                continue;
            }
            this.progress[i] = 0;
        }
        if (changed) {
            OvenBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean hasRecipe(int inputSlot, int outputSlot) {
        ItemStack inputStack = this.itemHandler.getStackInSlot(inputSlot);
        if (inputStack.isEmpty()) {
            return false;
        }
        Optional<RecipeHolder<OvenRecipe>> recipe = this.getRecipeFor(inputStack);
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = ((OvenRecipe)recipe.get().value()).output();
        return this.canInsert(output, outputSlot);
    }

    private Optional<RecipeHolder<OvenRecipe>> getRecipeFor(ItemStack input) {
        return ((ServerLevel)this.level).recipeAccess().getRecipeFor((RecipeType)ModRecipes.OVEN_TYPE.get(), (RecipeInput)new OvenRecipeInput(input), this.level);
    }

    private void craftItem(int inputSlot, int outputSlot) {
        ItemStack inputStack = this.itemHandler.getStackInSlot(inputSlot);
        Optional<RecipeHolder<OvenRecipe>> recipe = this.getRecipeFor(inputStack);
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack output = ((OvenRecipe)recipe.get().value()).output();
        this.itemHandler.extractItem(inputSlot, 1, false);
        ItemStack existing = this.itemHandler.getStackInSlot(outputSlot);
        if (existing.isEmpty()) {
            this.itemHandler.setStackInSlot(outputSlot, output.copy());
        } else {
            existing.grow(output.getCount());
        }
    }

    private boolean canInsert(ItemStack output, int slot) {
        ItemStack existing = this.itemHandler.getStackInSlot(slot);
        return existing.isEmpty() || existing.getItem() == output.getItem() && existing.getCount() + output.getCount() <= existing.getMaxStackSize();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        for (int i = 0; i < 3; ++i) {
            tag.putInt("progress" + i, this.progress[i]);
        }
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, (CompoundTag)tag.getCompound("inventory").get());
        for (int i = 0; i < 3; ++i) {
            this.progress[i] = (Integer)tag.getInt("progress" + i).get();
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

