/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.tier1234.better_deco.block.entity.ModBlockEntities;
import net.tier1234.better_deco.screen.ModInventory;
import net.tier1234.better_deco.screen.custom.ShelfMenu;
import org.jetbrains.annotations.Nullable;

public class ShelfBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider {
    public final ModInventory handler = new ModInventory(6, stack -> this.setChanged());

    public ShelfBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SHELF_BE.get(), pos, state);
    }

    protected Component getDefaultName() {
        return Component.literal((String)"Shelf");
    }

    public int getContainerSize() {
        return this.handler.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.getContainerSize(); ++i) {
            items.set(i, (Object)this.handler.getStackInSlot(i));
        }
        return items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            this.handler.setStackInSlot(i, (ItemStack)items.get(i));
        }
        this.setChanged();
    }

    public void clearContent() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        return !player.isSpectator() && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public int getComparatorOutput() {
        return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)this);
    }

    public static void dropContents(Level level, BlockPos pos, ShelfBlockEntity shelf) {
        Containers.dropContents((Level)level, (BlockPos)pos, (Container)shelf);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory) {
        return new ShelfMenu(containerId, playerInventory, (BlockEntity)this);
    }
}

