/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.block.entity.KitchenSinkBlockEntity;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class KitchenSinkBlockEntityRenderer
implements BlockEntityRenderer<KitchenSinkBlockEntity> {
    public KitchenSinkBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(KitchenSinkBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource source, int light, int overlay, Vec3 vec3) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        Direction direction = (Direction)tileEntity.getBlockState().getValue(FurnitureHorizontalBlock.DIRECTION);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)direction.get2DDataValue() * -90.0f - 90.0f));
        poseStack.translate(-0.5, -0.5, -0.5);
        this.drawFluid(tileEntity, poseStack, source, 0.125f, 0.625f, 0.125f, 0.625f, 0.3125f, 0.75f, light);
        poseStack.popPose();
    }

    private void drawFluid(KitchenSinkBlockEntity te, PoseStack poseStack, MultiBufferSource source, float x, float y, float z, float width, float height, float depth, int light) {
        FluidStack fluidStack = te.getTank().getFluid();
        Fluid fluid = fluidStack.getFluid();
        if (fluid == Fluids.EMPTY) {
            return;
        }
        IClientFluidTypeExtensions fluidType = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(fluidType.getStillTexture(fluid.defaultFluidState(), (BlockAndTintGetter)te.getLevel(), te.getBlockPos()));
        float minU = sprite.getU0();
        float maxU = Math.min(minU + (sprite.getU1() - minU) * depth, sprite.getU1());
        float minV = sprite.getV0();
        float maxV = Math.min(minV + (sprite.getV1() - minV) * width, sprite.getV1());
        int waterColor = fluidType.getTintColor(fluid.defaultFluidState(), (BlockAndTintGetter)te.getLevel(), te.getBlockPos());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        height = (float)((double)height * ((double)te.getTank().getFluidAmount() / (double)te.getTank().getCapacity()));
        VertexConsumer consumer = source.getBuffer(RenderType.translucent());
        Matrix4f matrix = poseStack.last().pose();
        consumer.addVertex(matrix, x, y + height, z).setColor(red, green, blue, 1.0f).setUv(maxU, minV).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix, x, y + height, z + depth).setColor(red, green, blue, 1.0f).setUv(minU, minV).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix, x + width, y + height, z + depth).setColor(red, green, blue, 1.0f).setUv(minU, maxV).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix, x + width, y + height, z).setColor(red, green, blue, 1.0f).setUv(maxU, maxV).setNormal(0.0f, 1.0f, 0.0f);
    }
}

