/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntityUtil {
    public static void sendUpdate(BlockEntity blockEntity) {
        Packet packet = blockEntity.getUpdatePacket();
        if (packet != null) {
            BlockEntityUtil.sendToChunkWatchers(blockEntity.getLevel(), blockEntity.getBlockPos(), packet);
        }
    }

    public static void sendUpdatePacket(BlockEntity blockEntity, CompoundTag tag) {
        BlockEntityUtil.writeIdAndPos(blockEntity, tag);
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)blockEntity, (entity, registryAccess) -> tag);
        BlockEntityUtil.sendToChunkWatchers(blockEntity.getLevel(), blockEntity.getBlockPos(), packet);
    }

    private static void writeIdAndPos(BlockEntity blockEntity, CompoundTag tag) {
        ResourceLocation id = Registries.BLOCK_ENTITY_TYPE.location();
        if (id != null) {
            tag.putString("id", id.toString());
            BlockPos pos = blockEntity.getBlockPos();
            tag.putInt("x", pos.getX());
            tag.putInt("y", pos.getY());
            tag.putInt("z", pos.getZ());
        }
    }

    private static void sendToChunkWatchers(Level level, BlockPos pos, Packet<?> packet) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        List players = serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(pos), false);
        for (ServerPlayer player : players) {
            player.connection.send(packet);
        }
    }
}

