/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.entity.ModEntities;
import org.jetbrains.annotations.Nullable;

public class BarStoolBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty COLOUR = IntegerProperty.create((String)"colour", (int)0, (int)15);
    private final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public BarStoolBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.stateDefinition.getPossibleStates());
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.box((double)2.0, (double)0.0, (double)2.0, (double)13.0, (double)9.0, (double)13.0);
        VoxelShape legFrontLeft = Block.box((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)13.0, (double)4.0);
        VoxelShape legFrontRight = Block.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)4.0);
        VoxelShape legBackLeft = Block.box((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)13.0, (double)14.0);
        VoxelShape legBackRight = Block.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)13.0, (double)14.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            ArrayList<VoxelShape> parts = new ArrayList<VoxelShape>();
            parts.add(baseShape);
            parts.add(legFrontLeft);
            parts.add(legFrontRight);
            parts.add(legBackLeft);
            parts.add(legBackRight);
            VoxelShape combined = (VoxelShape)parts.get(0);
            for (int i = 1; i < parts.size(); ++i) {
                combined = Shapes.or((VoxelShape)combined, (VoxelShape)((VoxelShape)parts.get(i)));
            }
            builder.put((Object)state, (Object)combined);
        }
        return builder.build();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COLOUR});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.getOrDefault((Object)state, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.getOrDefault((Object)state, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Entity entity = null;
            List entities = level.getEntities((EntityTypeTest)ModEntities.CHAIR_ENTITY.get(), new AABB(pos), chair -> true);
            if (entities.isEmpty() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                entity = ModEntities.CHAIR_ENTITY.get().spawn(serverLevel, pos, EntitySpawnReason.TRIGGERED);
            } else if (!entities.isEmpty()) {
                entity = (Entity)entities.get(0);
            }
            if (entity != null) {
                player.startRiding(entity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction dir = context.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)dir)).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0));
    }
}

