/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class DinningTableBlock
extends FurnitureHorizontalBlock {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public DinningTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return null;
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape TABLE_TOP_TALL = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape LEG_SOUTH_EAST_TALL = Block.box((double)13.5, (double)0.0, (double)13.5, (double)15.5, (double)14.0, (double)15.5);
        VoxelShape LEG_SOUTH_WEST_TALL = Block.box((double)0.5, (double)0.0, (double)13.5, (double)2.5, (double)14.0, (double)15.5);
        VoxelShape LEG_NORTH_WEST_TALL = Block.box((double)0.5, (double)0.0, (double)0.5, (double)2.5, (double)14.0, (double)2.5);
        VoxelShape LEG_NORTH_EAST_TALL = Block.box((double)13.5, (double)0.0, (double)0.5, (double)15.5, (double)14.0, (double)2.5);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.getValue((Property)NORTH);
            boolean east = (Boolean)state.getValue((Property)EAST);
            boolean south = (Boolean)state.getValue((Property)SOUTH);
            boolean west = (Boolean)state.getValue((Property)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TABLE_TOP_TALL);
            if (!north && !west) {
                shapes.add(LEG_NORTH_WEST_TALL);
            }
            if (!north && !east) {
                shapes.add(LEG_NORTH_EAST_TALL);
            }
            if (!south && !west) {
                shapes.add(LEG_SOUTH_WEST_TALL);
            }
            if (!south && !east) {
                shapes.add(LEG_SOUTH_EAST_TALL);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState updateShape(BlockState state, LevelReader reader, ScheduledTickAccess access, BlockPos pos, Direction direction, BlockPos pos1, BlockState state1, RandomSource rand) {
        boolean north = this.isCoffeeTable((LevelAccessor)reader, pos, Direction.NORTH);
        boolean east = this.isCoffeeTable((LevelAccessor)reader, pos, Direction.EAST);
        boolean south = this.isCoffeeTable((LevelAccessor)reader, pos, Direction.SOUTH);
        boolean west = this.isCoffeeTable((LevelAccessor)reader, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    private boolean isCoffeeTable(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.getBlockState(source.relative(direction));
        return state.getBlock() == this;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }
}

