/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.tier1234.better_deco.block.custom.FreezerBlock;
import net.tier1234.better_deco.block.custom.FurnitureHorizontalBlock;
import net.tier1234.better_deco.block.entity.core.BasicLootBlockEntity;
import net.tier1234.better_deco.block.entity.custom.FridgeBlockEntity;
import net.tier1234.better_deco.util.VoxelShapeHelper;

public class FridgeBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    private final Supplier<DeferredBlock<Block>> freezer;

    public FridgeBlock(BlockBehaviour.Properties properties, Supplier<DeferredBlock<Block>> freezer) {
        super(properties);
        this.freezer = freezer;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    public ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] DOOR = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)29.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            boolean open = (Boolean)state.getValue((Property)OPEN);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(Block.box((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));
            if (open) {
                shapes.add(BASE[direction.get2DDataValue()]);
                shapes.add(DOOR[direction.get2DDataValue()]);
            } else {
                shapes.add(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return context == CollisionContext.empty() ? Shapes.block() : (VoxelShape)this.SHAPES.get((Object)state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player playerEntity, BlockHitResult result) {
        BlockEntity blockEntity;
        if (((Direction)state.getValue((Property)DIRECTION)).getOpposite() == result.getDirection() && !level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof FridgeBlockEntity) {
            FridgeBlockEntity blockEntity2 = (FridgeBlockEntity)blockEntity;
            playerEntity.openMenu((MenuProvider)blockEntity2);
        }
        return InteractionResult.SUCCESS;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity blockEntity2 = (BasicLootBlockEntity)blockEntity;
            blockEntity2.updateOpenerCount();
        }
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPEN});
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState belowState = level.getBlockState(pos.below());
        if (belowState.getBlock() instanceof FreezerBlock) {
            level.setBlock(pos.below(), Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, pos.below(), Block.getId((BlockState)belowState));
        }
        super.playerWillDestroy(level, pos, state, player);
        return belowState;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FridgeBlockEntity(pos, state);
    }
}

