/*
 * Decompiled with CFR 0.152.
 */
package net.tier1234.better_deco.block.entity.custom;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public abstract class FluidContainerBlockEntity
extends BlockEntity {
    public static final int BUCKET_VOLUME = 1000;
    private FluidStack stack = new FluidStack(Fluids.EMPTY, 0);
    private final int capacity;

    public FluidContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int capacity) {
        super(type, pos, state);
        this.capacity = capacity;
    }

    public FluidStack getFluidStack() {
        return this.stack;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void setFluidStack(FluidStack stack) {
        this.stack = stack.getAmount() > this.capacity ? new FluidStack(stack.getFluid(), this.capacity) : stack;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.stack.isEmpty()) {
            return;
        }
        tag.put("FluidStack", (Tag)FluidStack.CODEC.encode((Object)this.stack, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("FluidName")) {
            String name = tag.getString("FluidName");
            if ("minecraft:empty".equals(name)) {
                this.stack = new FluidStack(Fluids.EMPTY, 0);
                return;
            }
            Optional fluid = BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)name));
            if (fluid.isEmpty()) {
                this.stack = new FluidStack(Fluids.EMPTY, 0);
                return;
            }
            int amount = Math.min(tag.getInt("Amount"), this.capacity);
            if (amount <= 0) {
                this.stack = new FluidStack(Fluids.EMPTY, 0);
                return;
            }
            Holder.Reference ref = (Holder.Reference)fluid.get();
            this.stack = new FluidStack((Holder)ref, amount);
        } else {
            this.stack = tag.contains("FluidStack") ? (FluidStack)((Pair)FluidStack.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("FluidStack")).getOrThrow()).getFirst() : new FluidStack(Fluids.EMPTY, 0);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

